/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.retry.Repeat;
import reactor.retry.RepeatContext;
import reactor.retry.Retry;
import reactor.retry.RetryContext;

public class RetryGatewayFilterFactory
extends AbstractGatewayFilterFactory<RetryConfig> {
    public static final String RETRY_ITERATION_KEY = "retry_iteration";
    private static final Log log = LogFactory.getLog(RetryGatewayFilterFactory.class);

    public RetryGatewayFilterFactory() {
        super(RetryConfig.class);
    }

    @Override
    public GatewayFilter apply(RetryConfig retryConfig) {
        retryConfig.validate();
        Repeat statusCodeRepeat = null;
        if (!retryConfig.getStatuses().isEmpty() || !retryConfig.getSeries().isEmpty()) {
            Predicate<RepeatContext> repeatPredicate = context -> {
                boolean retryableMethod;
                ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
                if (this.exceedsMaxIterations(exchange, retryConfig)) {
                    return false;
                }
                HttpStatus statusCode = exchange.getResponse().getStatusCode();
                HttpMethod httpMethod = exchange.getRequest().getMethod();
                boolean retryableStatusCode = retryConfig.getStatuses().contains(statusCode);
                if (!retryableStatusCode && statusCode != null) {
                    retryableStatusCode = retryConfig.getSeries().stream().anyMatch(series -> statusCode.series().equals(series));
                }
                return (retryableMethod = retryConfig.getMethods().contains(httpMethod)) && retryableStatusCode;
            };
            statusCodeRepeat = Repeat.onlyIf(repeatPredicate).doOnRepeat(context -> this.reset((ServerWebExchange)context.applicationContext()));
        }
        Retry exceptionRetry = null;
        if (!retryConfig.getExceptions().isEmpty()) {
            Predicate<RetryContext> retryContextPredicate = context -> {
                if (this.exceedsMaxIterations((ServerWebExchange)context.applicationContext(), retryConfig)) {
                    return false;
                }
                for (Class<? extends Throwable> clazz : retryConfig.getExceptions()) {
                    if (!clazz.isInstance(context.exception())) continue;
                    return true;
                }
                return false;
            };
            exceptionRetry = Retry.onlyIf(retryContextPredicate).doOnRetry(context -> this.reset((ServerWebExchange)context.applicationContext())).retryMax(retryConfig.getRetries());
        }
        return this.apply((Repeat<ServerWebExchange>)statusCodeRepeat, exceptionRetry);
    }

    public boolean exceedsMaxIterations(ServerWebExchange exchange, RetryConfig retryConfig) {
        Integer iteration = (Integer)exchange.getAttribute(RETRY_ITERATION_KEY);
        return iteration != null && iteration >= retryConfig.getRetries();
    }

    public void reset(ServerWebExchange exchange) {
        exchange.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_ALREADY_ROUTED_ATTR);
    }

    public GatewayFilter apply(Repeat<ServerWebExchange> repeat, Retry<ServerWebExchange> retry) {
        return (exchange, chain) -> {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Entering retry-filter");
            }
            Mono publisher = chain.filter(exchange).doOnSuccessOrError((aVoid, throwable) -> {
                int iteration = (Integer)exchange.getAttributeOrDefault(RETRY_ITERATION_KEY, (Object)-1);
                exchange.getAttributes().put(RETRY_ITERATION_KEY, iteration + 1);
            });
            if (retry != null) {
                publisher = publisher.retryWhen((Function)retry.withApplicationContext((Object)exchange));
            }
            if (repeat != null) {
                publisher = publisher.repeatWhen((Function)repeat.withApplicationContext((Object)exchange));
            }
            return Mono.fromDirect((Publisher)publisher);
        };
    }

    private static <T> List<T> toList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    static /* synthetic */ List access$000(Object[] x0) {
        return RetryGatewayFilterFactory.toList(x0);
    }

    public static class RetryConfig {
        private int retries = 3;
        private List<HttpStatus.Series> series = RetryGatewayFilterFactory.access$000(new HttpStatus.Series[]{HttpStatus.Series.SERVER_ERROR});
        private List<HttpStatus> statuses = new ArrayList<HttpStatus>();
        private List<HttpMethod> methods = RetryGatewayFilterFactory.access$000(new HttpMethod[]{HttpMethod.GET});
        private List<Class<? extends Throwable>> exceptions = RetryGatewayFilterFactory.access$000(new Class[]{IOException.class, TimeoutException.class});

        public RetryConfig setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public RetryConfig setSeries(HttpStatus.Series ... series) {
            this.series = Arrays.asList(series);
            return this;
        }

        public RetryConfig setStatuses(HttpStatus ... statuses) {
            this.statuses = Arrays.asList(statuses);
            return this;
        }

        public RetryConfig setMethods(HttpMethod ... methods) {
            this.methods = Arrays.asList(methods);
            return this;
        }

        public RetryConfig allMethods() {
            return this.setMethods(HttpMethod.values());
        }

        public RetryConfig setExceptions(Class<? extends Throwable> ... exceptions) {
            this.exceptions = Arrays.asList(exceptions);
            return this;
        }

        public void validate() {
            Assert.isTrue((this.retries > 0 ? 1 : 0) != 0, (String)"retries must be greater than 0");
            Assert.isTrue((!this.series.isEmpty() || !this.statuses.isEmpty() || !this.exceptions.isEmpty() ? 1 : 0) != 0, (String)"series, status and exceptions may not all be empty");
            Assert.notEmpty(this.methods, (String)"methods may not be empty");
        }

        public int getRetries() {
            return this.retries;
        }

        public List<HttpStatus.Series> getSeries() {
            return this.series;
        }

        public List<HttpStatus> getStatuses() {
            return this.statuses;
        }

        public List<HttpMethod> getMethods() {
            return this.methods;
        }

        public List<Class<? extends Throwable>> getExceptions() {
            return this.exceptions;
        }
    }
}

