/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.server.PathContainer;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class PathRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final Log log = LogFactory.getLog(RoutePredicateFactory.class);
    private static final String MATCH_OPTIONAL_TRAILING_SEPARATOR_KEY = "matchOptionalTrailingSeparator";
    private PathPatternParser pathPatternParser = new PathPatternParser();

    public PathRoutePredicateFactory() {
        super(Config.class);
    }

    public void setPathPatternParser(PathPatternParser pathPatternParser) {
        this.pathPatternParser = pathPatternParser;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("pattern", MATCH_OPTIONAL_TRAILING_SEPARATOR_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        PathPatternParser pathPatternParser = this.pathPatternParser;
        synchronized (pathPatternParser) {
            this.pathPatternParser.setMatchOptionalTrailingSeparator(config.isMatchOptionalTrailingSeparator());
            config.pathPattern = this.pathPatternParser.parse(config.pattern);
        }
        return exchange -> {
            PathContainer path = PathContainer.parsePath((String)exchange.getRequest().getURI().getPath());
            boolean match = config.pathPattern.matches(path);
            PathRoutePredicateFactory.traceMatch("Pattern", config.pathPattern.getPatternString(), path, match);
            if (match) {
                PathPattern.PathMatchInfo pathMatchInfo = config.pathPattern.matchAndExtract(path);
                ServerWebExchangeUtils.putUriTemplateVariables(exchange, pathMatchInfo.getUriVariables());
            }
            return match;
        };
    }

    private static void traceMatch(String prefix, Object desired, Object actual, boolean match) {
        if (log.isTraceEnabled()) {
            String message = String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual);
            log.trace((Object)message);
        }
    }

    @Validated
    public static class Config {
        private String pattern;
        private PathPattern pathPattern;
        private boolean matchOptionalTrailingSeparator = true;

        public String getPattern() {
            return this.pattern;
        }

        public Config setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public boolean isMatchOptionalTrailingSeparator() {
            return this.matchOptionalTrailingSeparator;
        }

        public Config setMatchOptionalTrailingSeparator(boolean matchOptionalTrailingSeparator) {
            this.matchOptionalTrailingSeparator = matchOptionalTrailingSeparator;
            return this;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("pattern", (Object)this.pattern).append(PathRoutePredicateFactory.MATCH_OPTIONAL_TRAILING_SEPARATOR_KEY, this.matchOptionalTrailingSeparator).toString();
        }
    }
}

