/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractChangeRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.HystrixGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PrefixPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PreserveHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RedirectToGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestHeaderToRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestRateLimiterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewritePathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SaveSessionGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetStatusGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.StripPrefixGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyRequestBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyResponseBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.route.builder.UriSpec;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.retry.Repeat;
import reactor.retry.Retry;

public class GatewayFilterSpec
extends UriSpec {
    private static final Log log = LogFactory.getLog(GatewayFilterSpec.class);

    public GatewayFilterSpec(Route.AsyncBuilder routeBuilder, RouteLocatorBuilder.Builder builder) {
        super(routeBuilder, builder);
    }

    public GatewayFilterSpec filter(GatewayFilter gatewayFilter) {
        if (gatewayFilter instanceof Ordered) {
            this.routeBuilder.filter(gatewayFilter);
            return this;
        }
        return this.filter(gatewayFilter, 0);
    }

    public GatewayFilterSpec filter(GatewayFilter gatewayFilter, int order) {
        if (gatewayFilter instanceof Ordered) {
            this.routeBuilder.filter(gatewayFilter);
            log.warn((Object)("GatewayFilter already implements ordered " + gatewayFilter.getClass() + "ignoring order parameter: " + order));
            return this;
        }
        this.routeBuilder.filter(new OrderedGatewayFilter(gatewayFilter, order));
        return this;
    }

    public GatewayFilterSpec filters(GatewayFilter ... gatewayFilters) {
        List<GatewayFilter> filters = this.transformToOrderedFilters(Stream.of(gatewayFilters));
        this.routeBuilder.filters(filters);
        return this;
    }

    public List<GatewayFilter> transformToOrderedFilters(Stream<GatewayFilter> stream) {
        return stream.map(filter -> {
            if (filter instanceof Ordered) {
                return filter;
            }
            return new OrderedGatewayFilter((GatewayFilter)filter, 0);
        }).collect(Collectors.toList());
    }

    public GatewayFilterSpec filters(Collection<GatewayFilter> gatewayFilters) {
        List<GatewayFilter> filters = this.transformToOrderedFilters(gatewayFilters.stream());
        this.routeBuilder.filters(filters);
        return this;
    }

    public GatewayFilterSpec addRequestHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(AddRequestHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec addRequestParameter(String param, String value) {
        return this.filter(this.getBean(AddRequestParameterGatewayFilterFactory.class).apply(c -> c.setName(param).setValue(value)));
    }

    public GatewayFilterSpec addResponseHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(AddResponseHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec hystrix(Consumer<HystrixGatewayFilterFactory.Config> configConsumer) {
        HystrixGatewayFilterFactory factory;
        try {
            factory = this.getBean(HystrixGatewayFilterFactory.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new NoSuchBeanDefinitionException(HystrixGatewayFilterFactory.class, "This is probably because Hystrix is missing from the classpath, which can be resolved by adding dependency on 'org.springframework.cloud:spring-cloud-starter-netflix-hystrix'");
        }
        return this.filter(factory.apply(this.routeBuilder.getId(), configConsumer));
    }

    public <T, R> GatewayFilterSpec modifyRequestBody(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyRequestBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction)));
    }

    public <T, R> GatewayFilterSpec modifyRequestBody(Class<T> inClass, Class<R> outClass, String newContentType, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyRequestBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction).setContentType(newContentType)));
    }

    public <T, R> GatewayFilterSpec modifyResponseBody(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyResponseBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction)));
    }

    public <T, R> GatewayFilterSpec modifyResponseBody(Class<T> inClass, Class<R> outClass, String newContentType, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyResponseBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction).setNewContentType(newContentType)));
    }

    public GatewayFilterSpec prefixPath(String prefix) {
        return this.filter(this.getBean(PrefixPathGatewayFilterFactory.class).apply(c -> c.setPrefix(prefix)));
    }

    public GatewayFilterSpec preserveHostHeader() {
        return this.filter(this.getBean(PreserveHostHeaderGatewayFilterFactory.class).apply());
    }

    public GatewayFilterSpec redirect(int status, URI url) {
        return this.redirect(String.valueOf(status), url.toString());
    }

    public GatewayFilterSpec redirect(int status, String url) {
        return this.redirect(String.valueOf(status), url);
    }

    public GatewayFilterSpec redirect(String status, URI url) {
        return this.redirect(status, url);
    }

    public GatewayFilterSpec redirect(String status, String url) {
        return this.filter(this.getBean(RedirectToGatewayFilterFactory.class).apply(status, url));
    }

    public GatewayFilterSpec redirect(HttpStatus status, URL url) {
        try {
            return this.filter(this.getBean(RedirectToGatewayFilterFactory.class).apply(status, url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
    }

    public GatewayFilterSpec removeRequestHeader(String headerName) {
        return this.filter(this.getBean(RemoveRequestHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName)));
    }

    public GatewayFilterSpec removeResponseHeader(String headerName) {
        return this.filter(this.getBean(RemoveResponseHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName)));
    }

    public GatewayFilterSpec requestRateLimiter(Consumer<RequestRateLimiterGatewayFilterFactory.Config> configConsumer) {
        return this.filter(this.getBean(RequestRateLimiterGatewayFilterFactory.class).apply(configConsumer));
    }

    public RequestRateLimiterSpec requestRateLimiter() {
        return new RequestRateLimiterSpec(this.getBean(RequestRateLimiterGatewayFilterFactory.class));
    }

    public GatewayFilterSpec rewritePath(String regex, String replacement) {
        return this.filter(this.getBean(RewritePathGatewayFilterFactory.class).apply(c -> c.setRegexp(regex).setReplacement(replacement)));
    }

    public GatewayFilterSpec retry(int retries) {
        return this.filter(this.getBean(RetryGatewayFilterFactory.class).apply(retryConfig -> retryConfig.setRetries(retries)));
    }

    public GatewayFilterSpec retry(Consumer<RetryGatewayFilterFactory.RetryConfig> retryConsumer) {
        return this.filter(this.getBean(RetryGatewayFilterFactory.class).apply(retryConsumer));
    }

    public GatewayFilterSpec retry(Repeat<ServerWebExchange> repeat, Retry<ServerWebExchange> retry) {
        return this.filter(this.getBean(RetryGatewayFilterFactory.class).apply(repeat, retry));
    }

    public GatewayFilterSpec secureHeaders() {
        return this.filter(this.getBean(SecureHeadersGatewayFilterFactory.class).apply(c -> {}));
    }

    public GatewayFilterSpec setPath(String template) {
        return this.filter(this.getBean(SetPathGatewayFilterFactory.class).apply(c -> c.setTemplate(template)));
    }

    public GatewayFilterSpec setRequestHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(SetRequestHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec setResponseHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(SetResponseHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec rewriteResponseHeader(String headerName, String regex, String replacement) {
        return this.filter(this.getBean(RewriteResponseHeaderGatewayFilterFactory.class).apply(c -> c.setReplacement(replacement).setRegexp(regex).setName(headerName)));
    }

    public GatewayFilterSpec setStatus(int status) {
        return this.setStatus(String.valueOf(status));
    }

    public GatewayFilterSpec setStatus(HttpStatus status) {
        return this.setStatus(status.toString());
    }

    public GatewayFilterSpec setStatus(String status) {
        return this.filter(this.getBean(SetStatusGatewayFilterFactory.class).apply(c -> c.setStatus(status)));
    }

    public GatewayFilterSpec saveSession() {
        return this.filter(this.getBean(SaveSessionGatewayFilterFactory.class).apply(c -> {}));
    }

    public GatewayFilterSpec stripPrefix(int parts) {
        return this.filter(this.getBean(StripPrefixGatewayFilterFactory.class).apply(c -> c.setParts(parts)));
    }

    public GatewayFilterSpec requestHeaderToRequestUri(String headerName) {
        return this.filter(this.getBean(RequestHeaderToRequestUriGatewayFilterFactory.class).apply(c -> c.setName(headerName)));
    }

    public GatewayFilterSpec changeRequestUri(final Function<ServerWebExchange, Optional<URI>> determineRequestUri) {
        return this.filter(new AbstractChangeRequestUriGatewayFilterFactory<Object>(Object.class){

            @Override
            protected Optional<URI> determineRequestUri(ServerWebExchange exchange, Object config) {
                return (Optional)determineRequestUri.apply(exchange);
            }
        }.apply(c -> {}));
    }

    public class RequestRateLimiterSpec {
        private final RequestRateLimiterGatewayFilterFactory filter;

        public RequestRateLimiterSpec(RequestRateLimiterGatewayFilterFactory filter) {
            this.filter = filter;
        }

        public <C, R extends RateLimiter<C>> RequestRateLimiterSpec rateLimiter(Class<R> rateLimiterType, Consumer<C> configConsumer) {
            RateLimiter rateLimiter = (RateLimiter)GatewayFilterSpec.this.getBean(rateLimiterType);
            Object config = rateLimiter.newConfig();
            configConsumer.accept(config);
            rateLimiter.getConfig().put(GatewayFilterSpec.this.routeBuilder.getId(), config);
            return this;
        }

        public GatewayFilterSpec configure(Consumer<RequestRateLimiterGatewayFilterFactory.Config> configConsumer) {
            GatewayFilterSpec.this.filter(this.filter.apply(configConsumer));
            return GatewayFilterSpec.this;
        }

        public GatewayFilterSpec and() {
            return this.configure(config -> {});
        }
    }
}

