/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.discovery;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.core.style.ToStringCreator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class DiscoveryClientRouteDefinitionLocator
implements RouteDefinitionLocator {
    private static final Log log = LogFactory.getLog(DiscoveryClientRouteDefinitionLocator.class);
    private final DiscoveryLocatorProperties properties;
    private final String routeIdPrefix;
    private final SimpleEvaluationContext evalCtxt;
    private Flux<List<ServiceInstance>> serviceInstances;

    @Deprecated
    public DiscoveryClientRouteDefinitionLocator(DiscoveryClient discoveryClient, DiscoveryLocatorProperties properties) {
        this(discoveryClient.getClass().getSimpleName(), properties);
        this.serviceInstances = Flux.defer(() -> Flux.fromIterable((Iterable)discoveryClient.getServices())).map(arg_0 -> ((DiscoveryClient)discoveryClient).getInstances(arg_0)).subscribeOn(Schedulers.boundedElastic());
    }

    public DiscoveryClientRouteDefinitionLocator(ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties) {
        this(discoveryClient.getClass().getSimpleName(), properties);
        this.serviceInstances = discoveryClient.getServices().flatMap(service -> discoveryClient.getInstances(service).collectList());
    }

    private DiscoveryClientRouteDefinitionLocator(String discoveryClientName, DiscoveryLocatorProperties properties) {
        this.properties = properties;
        this.routeIdPrefix = StringUtils.hasText((String)properties.getRouteIdPrefix()) ? properties.getRouteIdPrefix() : discoveryClientName + "_";
        this.evalCtxt = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    }

    @Override
    public Flux<RouteDefinition> getRouteDefinitions() {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression includeExpr = parser.parseExpression(this.properties.getIncludeExpression());
        Expression urlExpr = parser.parseExpression(this.properties.getUrlExpression());
        Predicate<ServiceInstance> includePredicate = this.properties.getIncludeExpression() == null || "true".equalsIgnoreCase(this.properties.getIncludeExpression()) ? instance -> true : instance -> {
            Boolean include = (Boolean)includeExpr.getValue((EvaluationContext)this.evalCtxt, instance, Boolean.class);
            if (include == null) {
                return false;
            }
            return include;
        };
        return this.serviceInstances.filter(instances -> !instances.isEmpty()).map(instances -> (ServiceInstance)instances.get(0)).filter(includePredicate).map(instance -> {
            String value;
            String serviceId = instance.getServiceId();
            RouteDefinition routeDefinition = new RouteDefinition();
            routeDefinition.setId(this.routeIdPrefix + serviceId);
            String uri = (String)urlExpr.getValue((EvaluationContext)this.evalCtxt, instance, String.class);
            routeDefinition.setUri(URI.create(uri));
            DelegatingServiceInstance instanceForEval = new DelegatingServiceInstance((ServiceInstance)instance, this.properties);
            for (PredicateDefinition predicateDefinition : this.properties.getPredicates()) {
                PredicateDefinition predicate = new PredicateDefinition();
                predicate.setName(predicateDefinition.getName());
                for (Map.Entry<String, String> entry : predicateDefinition.getArgs().entrySet()) {
                    value = this.getValueFromExpr(this.evalCtxt, parser, instanceForEval, entry);
                    predicate.addArg(entry.getKey(), value);
                }
                routeDefinition.getPredicates().add(predicate);
            }
            for (FilterDefinition filterDefinition : this.properties.getFilters()) {
                FilterDefinition filter = new FilterDefinition();
                filter.setName(filterDefinition.getName());
                for (Map.Entry<String, String> entry : filterDefinition.getArgs().entrySet()) {
                    value = this.getValueFromExpr(this.evalCtxt, parser, instanceForEval, entry);
                    filter.addArg(entry.getKey(), value);
                }
                routeDefinition.getFilters().add(filter);
            }
            return routeDefinition;
        });
    }

    String getValueFromExpr(SimpleEvaluationContext evalCtxt, SpelExpressionParser parser, ServiceInstance instance, Map.Entry<String, String> entry) {
        try {
            Expression valueExpr = parser.parseExpression(entry.getValue());
            return (String)valueExpr.getValue((EvaluationContext)evalCtxt, (Object)instance, String.class);
        }
        catch (EvaluationException | ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to parse " + entry.getValue()), e);
            }
            throw e;
        }
    }

    private static class DelegatingServiceInstance
    implements ServiceInstance {
        final ServiceInstance delegate;
        private final DiscoveryLocatorProperties properties;

        private DelegatingServiceInstance(ServiceInstance delegate, DiscoveryLocatorProperties properties) {
            this.delegate = delegate;
            this.properties = properties;
        }

        public String getServiceId() {
            if (this.properties.isLowerCaseServiceId()) {
                return this.delegate.getServiceId().toLowerCase();
            }
            return this.delegate.getServiceId();
        }

        public String getHost() {
            return this.delegate.getHost();
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public boolean isSecure() {
            return this.delegate.isSecure();
        }

        public URI getUri() {
            return this.delegate.getUri();
        }

        public Map<String, String> getMetadata() {
            return this.delegate.getMetadata();
        }

        public String getScheme() {
            return this.delegate.getScheme();
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("delegate", (Object)this.delegate).append("properties", (Object)this.properties).toString();
        }
    }
}

