/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RemoveCachedBodyFilter
implements GlobalFilter,
Ordered {
    private static final Log log = LogFactory.getLog(RemoveCachedBodyFilter.class);

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return chain.filter(exchange).doFinally(s -> {
            PooledDataBuffer dataBuffer = (PooledDataBuffer)exchange.getAttributes().remove("cachedRequestBody");
            if (dataBuffer != null && dataBuffer.isAllocated()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"releasing cached body in exchange attribute");
                }
                dataBuffer.release();
            }
        });
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

