/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersProperties;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SecureHeadersGatewayFilterFactory
extends AbstractGatewayFilterFactory {
    public static final String X_XSS_PROTECTION_HEADER = "X-Xss-Protection";
    public static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    public static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    public static final String X_CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    public static final String REFERRER_POLICY_HEADER = "Referrer-Policy";
    public static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    public static final String X_DOWNLOAD_OPTIONS_HEADER = "X-Download-Options";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER = "X-Permitted-Cross-Domain-Policies";
    private final SecureHeadersProperties properties;

    public SecureHeadersGatewayFilterFactory(SecureHeadersProperties properties) {
        this.properties = properties;
    }

    @Override
    public GatewayFilter apply(Object config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                HttpHeaders headers = exchange.getResponse().getHeaders();
                List<String> disabled = SecureHeadersGatewayFilterFactory.this.properties.getDisable();
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_XSS_PROTECTION_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.X_XSS_PROTECTION_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getXssProtectionHeader());
                }
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.STRICT_TRANSPORT_SECURITY_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.STRICT_TRANSPORT_SECURITY_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getStrictTransportSecurity());
                }
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_FRAME_OPTIONS_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.X_FRAME_OPTIONS_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getFrameOptions());
                }
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_CONTENT_TYPE_OPTIONS_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.X_CONTENT_TYPE_OPTIONS_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getContentTypeOptions());
                }
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.REFERRER_POLICY_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.REFERRER_POLICY_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getReferrerPolicy());
                }
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.CONTENT_SECURITY_POLICY_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.CONTENT_SECURITY_POLICY_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getContentSecurityPolicy());
                }
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_DOWNLOAD_OPTIONS_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.X_DOWNLOAD_OPTIONS_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getDownloadOptions());
                }
                if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER)) {
                    headers.add(SecureHeadersGatewayFilterFactory.X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER, SecureHeadersGatewayFilterFactory.this.properties.getPermittedCrossDomainPolicies());
                }
                return chain.filter(exchange);
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(SecureHeadersGatewayFilterFactory.this).toString();
            }
        };
    }

    private boolean isEnabled(List<String> disabledHeaders, String header) {
        return !disabledHeaders.contains(header.toLowerCase());
    }
}

