/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

@ConfigurationProperties(value="spring.cloud.gateway.x-forwarded")
public class XForwardedHeadersFilter
implements HttpHeadersFilter,
Ordered {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    public static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    public static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    public static final String X_FORWARDED_PREFIX_HEADER = "X-Forwarded-Prefix";
    private int order = 0;
    private boolean enabled = true;
    private boolean forEnabled = true;
    private boolean hostEnabled = true;
    private boolean portEnabled = true;
    private boolean protoEnabled = true;
    private boolean prefixEnabled = true;
    private boolean forAppend = true;
    private boolean hostAppend = true;
    private boolean portAppend = true;
    private boolean protoAppend = true;
    private boolean prefixAppend = true;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isForEnabled() {
        return this.forEnabled;
    }

    public void setForEnabled(boolean forEnabled) {
        this.forEnabled = forEnabled;
    }

    public boolean isHostEnabled() {
        return this.hostEnabled;
    }

    public void setHostEnabled(boolean hostEnabled) {
        this.hostEnabled = hostEnabled;
    }

    public boolean isPortEnabled() {
        return this.portEnabled;
    }

    public void setPortEnabled(boolean portEnabled) {
        this.portEnabled = portEnabled;
    }

    public boolean isProtoEnabled() {
        return this.protoEnabled;
    }

    public void setProtoEnabled(boolean protoEnabled) {
        this.protoEnabled = protoEnabled;
    }

    public boolean isPrefixEnabled() {
        return this.prefixEnabled;
    }

    public void setPrefixEnabled(boolean prefixEnabled) {
        this.prefixEnabled = prefixEnabled;
    }

    public boolean isForAppend() {
        return this.forAppend;
    }

    public void setForAppend(boolean forAppend) {
        this.forAppend = forAppend;
    }

    public boolean isHostAppend() {
        return this.hostAppend;
    }

    public void setHostAppend(boolean hostAppend) {
        this.hostAppend = hostAppend;
    }

    public boolean isPortAppend() {
        return this.portAppend;
    }

    public void setPortAppend(boolean portAppend) {
        this.portAppend = portAppend;
    }

    public boolean isProtoAppend() {
        return this.protoAppend;
    }

    public void setProtoAppend(boolean protoAppend) {
        this.protoAppend = protoAppend;
    }

    public boolean isPrefixAppend() {
        return this.prefixAppend;
    }

    public void setPrefixAppend(boolean prefixAppend) {
        this.prefixAppend = prefixAppend;
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        original.entrySet().stream().forEach(entry -> updated.addAll((String)entry.getKey(), (List)entry.getValue()));
        if (this.isForEnabled() && request.getRemoteAddress() != null && request.getRemoteAddress().getAddress() != null) {
            String remoteAddr = request.getRemoteAddress().getAddress().getHostAddress();
            this.write(updated, X_FORWARDED_FOR_HEADER, remoteAddr, this.isForAppend());
        }
        String proto = request.getURI().getScheme();
        if (this.isProtoEnabled()) {
            this.write(updated, X_FORWARDED_PROTO_HEADER, proto, this.isProtoAppend());
        }
        if (this.isPrefixEnabled()) {
            LinkedHashSet originalUris = (LinkedHashSet)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
            URI requestUri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
            if (originalUris != null && requestUri != null) {
                originalUris.stream().forEach(originalUri -> {
                    if (originalUri != null && originalUri.getPath() != null) {
                        String prefix = originalUri.getPath();
                        String originalUriPath = this.stripTrailingSlash((URI)originalUri);
                        String requestUriPath = this.stripTrailingSlash(requestUri);
                        this.updateRequest(updated, (URI)originalUri, originalUriPath, requestUriPath);
                    }
                });
            }
        }
        if (this.isPortEnabled()) {
            String port = String.valueOf(request.getURI().getPort());
            if (request.getURI().getPort() < 0) {
                port = String.valueOf(this.getDefaultPort(proto));
            }
            this.write(updated, X_FORWARDED_PORT_HEADER, port, this.isPortAppend());
        }
        if (this.isHostEnabled()) {
            String host = this.toHostHeader(request);
            this.write(updated, X_FORWARDED_HOST_HEADER, host, this.isHostAppend());
        }
        return updated;
    }

    private void updateRequest(HttpHeaders updated, URI originalUri, String originalUriPath, String requestUriPath) {
        String prefix;
        if (requestUriPath != null && originalUriPath.endsWith(requestUriPath) && (prefix = XForwardedHeadersFilter.substringBeforeLast(originalUriPath, requestUriPath)) != null && prefix.length() > 0 && prefix.length() <= originalUri.getPath().length()) {
            this.write(updated, X_FORWARDED_PREFIX_HEADER, prefix, this.isPrefixAppend());
        }
    }

    private static String substringBeforeLast(String str, String separator) {
        if (StringUtils.isEmpty((Object)str) || StringUtils.isEmpty((Object)separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append) {
        if (append) {
            headers.add(name, value);
            List values = headers.get((Object)name);
            String delimitedValue = StringUtils.collectionToCommaDelimitedString((Collection)values);
            headers.set(name, delimitedValue);
        } else {
            headers.set(name, value);
        }
    }

    private int getDefaultPort(String scheme) {
        return HTTPS_SCHEME.equals(scheme) ? 443 : 80;
    }

    private boolean hasHeader(ServerHttpRequest request, String name) {
        HttpHeaders headers = request.getHeaders();
        return headers.containsKey((Object)name) && StringUtils.hasLength((String)headers.getFirst(name));
    }

    private String toHostHeader(ServerHttpRequest request) {
        int port = request.getURI().getPort();
        String host = request.getURI().getHost();
        String scheme = request.getURI().getScheme();
        if (port < 0 || port == 80 && HTTP_SCHEME.equals(scheme) || port == 443 && HTTPS_SCHEME.equals(scheme)) {
            return host;
        }
        return host + ":" + port;
    }

    private String stripTrailingSlash(URI uri) {
        if (uri.getPath().endsWith("/")) {
            return uri.getPath().substring(0, uri.getPath().length() - 1);
        }
        return uri.getPath();
    }
}

