/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RewriteResponseHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String REGEXP_KEY = "regexp";
    public static final String REPLACEMENT_KEY = "replacement";

    public RewriteResponseHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", REGEXP_KEY, REPLACEMENT_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> RewriteResponseHeaderGatewayFilterFactory.this.rewriteHeaders(exchange, config)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RewriteResponseHeaderGatewayFilterFactory.this).append("name", (Object)config.getName()).append(RewriteResponseHeaderGatewayFilterFactory.REGEXP_KEY, (Object)config.getRegexp()).append(RewriteResponseHeaderGatewayFilterFactory.REPLACEMENT_KEY, (Object)config.getReplacement()).toString();
            }
        };
    }

    @Deprecated
    protected void rewriteHeader(ServerWebExchange exchange, Config config) {
        this.rewriteHeaders(exchange, config);
    }

    protected void rewriteHeaders(ServerWebExchange exchange, Config config) {
        String name = config.getName();
        HttpHeaders responseHeaders = exchange.getResponse().getHeaders();
        responseHeaders.computeIfPresent((Object)name, (k, v) -> this.rewriteHeaders(config, (List<String>)v));
    }

    protected List<String> rewriteHeaders(Config config, List<String> headers) {
        return headers.stream().map(val -> this.rewrite((String)val, config.getRegexp(), config.getReplacement())).collect(Collectors.toList());
    }

    String rewrite(String value, String regexp, String replacement) {
        return value.replaceAll(regexp, replacement.replace("$\\", "$"));
    }

    public static class Config
    extends AbstractGatewayFilterFactory.NameConfig {
        private String regexp;
        private String replacement;

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public Config setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }
    }
}

