/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.actuate;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Maps;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.server.ServerWebExchange;

@RunWith(value=SpringRunner.class)
@SpringBootTest(properties={"management.endpoints.web.exposure.include=*", "spring.cloud.gateway.actuator.verbose.enabled=true"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class GatewayControllerEndpointTests {
    @Autowired
    WebTestClient testClient;
    @LocalServerPort
    int port;

    @Test
    public void testRefresh() {
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh", new Object[0])).exchange().expectStatus().isOk();
    }

    @Test
    public void testRoutes() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            Assertions.assertThat((List)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testGetSpecificRoute() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-service", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            Assertions.assertThat((List)responseBody).isNotNull();
            Assertions.assertThat((int)responseBody.size()).isEqualTo(1);
            Assertions.assertThat((List)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testRouteReturnsMetadata() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes/route_with_metadata", new Object[0]).exchange().expectStatus().isOk().expectBody().jsonPath("$.metadata", new Object[0]).value(map -> {
            MapAssert cfr_ignored_0 = (MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)map)).hasSize(3)).containsEntry((Object)"optionName", (Object)"OptionValue")).containsEntry((Object)"iAmNumber", (Object)1)).containsEntry((Object)"compositeObject", (Object)Maps.newHashMap((Object)"name", (Object)"value"));
        });
    }

    @Test
    public void testRouteFilters() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routefilters", new Object[0]).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map responseBody = (Map)result.getResponseBody();
            Assertions.assertThat((Map)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testRoutePredicates() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routepredicates", new Object[0]).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map responseBody = (Map)result.getResponseBody();
            Assertions.assertThat((Map)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testPostValidRouteDefinition() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        FilterDefinition prefixPathFilterDefinition = new FilterDefinition("PrefixPath=/test-path");
        FilterDefinition redirectToFilterDefinition = new FilterDefinition("RemoveResponseHeader=Sensitive-Header");
        FilterDefinition testFilterDefinition = new FilterDefinition("TestFilter");
        testRouteDefinition.setFilters(Arrays.asList(prefixPathFilterDefinition, redirectToFilterDefinition, testFilterDefinition));
        PredicateDefinition hostRoutePredicateDefinition = new PredicateDefinition("Host=myhost.org");
        PredicateDefinition methodRoutePredicateDefinition = new PredicateDefinition("Method=GET");
        PredicateDefinition testPredicateDefinition = new PredicateDefinition("Test=value");
        testRouteDefinition.setPredicates(Arrays.asList(hostRoutePredicateDefinition, methodRoutePredicateDefinition, testPredicateDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
    }

    @Test
    public void testPostRouteWithNotExistingFilter() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        FilterDefinition filterDefinition = new FilterDefinition("NotExistingFilter=test-config");
        testRouteDefinition.setFilters(Collections.singletonList(filterDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isBadRequest();
    }

    @Test
    public void testPostRouteWithNotExistingPredicate() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        PredicateDefinition predicateDefinition = new PredicateDefinition("NotExistingPredicate=test-config");
        testRouteDefinition.setPredicates(Collections.singletonList(predicateDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isBadRequest();
    }

    private static class TestRoutePredicateFactory
    extends AbstractRoutePredicateFactory {
        TestRoutePredicateFactory(Class configClass) {
            super(configClass);
        }

        public Predicate<ServerWebExchange> apply(Object config) {
            return serverWebExchange -> true;
        }
    }

    private static class TestFilterGatewayFilterFactory
    extends AbstractGatewayFilterFactory {
        private TestFilterGatewayFilterFactory() {
        }

        public GatewayFilter apply(Object config) {
            return null;
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        RouteLocator testRouteLocator(RouteLocatorBuilder routeLocatorBuilder) {
            return routeLocatorBuilder.routes().route("test-service", r -> r.path(new String[]{"/test-service/**"}).uri("lb://test-service")).build();
        }

        @Bean
        public TestFilterGatewayFilterFactory customGatewayFilterFactory() {
            return new TestFilterGatewayFilterFactory();
        }

        @Bean
        public TestRoutePredicateFactory customGatewayPredicateFactory() {
            return new TestRoutePredicateFactory(Object.class);
        }
    }
}

