/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.reactive.ReactiveOAuth2ClientAutoConfiguration;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.runner.ReactiveWebApplicationContextRunner;
import org.springframework.cloud.gateway.actuate.GatewayControllerEndpoint;
import org.springframework.cloud.gateway.actuate.GatewayLegacyControllerEndpoint;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.config.GatewayReactiveOAuth2AutoConfiguration;
import org.springframework.cloud.gateway.config.HttpClientCustomizer;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.filter.factory.TokenRelayGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.GatewayFilterSpec;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.web.filter.reactive.HiddenHttpMethodFilter;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.server.upgrade.ReactorNettyRequestUpgradeStrategy;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.server.WebsocketServerSpec;

public class GatewayAutoConfigurationTests {
    @Test
    public void noHiddenHttpMethodFilter() {
        try (ConfigurableApplicationContext ctx = SpringApplication.run(Config.class, (String[])new String[]{"--spring.jmx.enabled=false", "--server.port=0"});){
            Assertions.assertThat((String)ctx.getEnvironment().getProperty("spring.webflux.hiddenmethod.filter.enabled")).isEqualTo("false");
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(HiddenHttpMethodFilter.class)).isEmpty();
        }
    }

    @Test
    public void nettyHttpClientDefaults() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class}))).withPropertyValues(new String[]{"debug=true"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(HttpClient.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasBean("gatewayHttpClient");
            HttpClient httpClient = (HttpClient)context.getBean(HttpClient.class);
        });
    }

    @Test
    public void nettyHttpClientConfigured() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{WebFluxAutoConfiguration.class, MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GatewayAutoConfiguration.class, HttpClientCustomizedConfig.class}))).withPropertyValues(new String[]{"spring.cloud.gateway.httpclient.ssl.use-insecure-trust-manager=true", "spring.cloud.gateway.httpclient.connect-timeout=10", "spring.cloud.gateway.httpclient.response-timeout=10s", "spring.cloud.gateway.httpclient.pool.type=fixed", "spring.cloud.gateway.httpclient.compression=true", "spring.cloud.gateway.httpclient.max-initial-line-length=2147483647", "spring.cloud.gateway.httpclient.proxy.host=myhost", "spring.cloud.gateway.httpclient.websocket.max-frame-payload-length=1024"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(HttpClient.class);
            HttpClient httpClient = (HttpClient)context.getBean(HttpClient.class);
            HttpClientProperties properties = (HttpClientProperties)context.getBean(HttpClientProperties.class);
            Assertions.assertThat((long)properties.getMaxInitialLineLength().toBytes()).isLessThanOrEqualTo(Integer.MAX_VALUE);
            Assertions.assertThat((boolean)properties.isCompression()).isEqualTo(true);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ReactorNettyRequestUpgradeStrategy.class);
            ReactorNettyRequestUpgradeStrategy upgradeStrategy = (ReactorNettyRequestUpgradeStrategy)context.getBean(ReactorNettyRequestUpgradeStrategy.class);
            Assertions.assertThat((int)upgradeStrategy.getWebsocketServerSpec().maxFramePayloadLength()).isEqualTo(1024);
            Assertions.assertThat((boolean)upgradeStrategy.getWebsocketServerSpec().handlePing()).isTrue();
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ReactorNettyWebSocketClient.class);
            ReactorNettyWebSocketClient webSocketClient = (ReactorNettyWebSocketClient)context.getBean(ReactorNettyWebSocketClient.class);
            Assertions.assertThat((int)webSocketClient.getWebsocketClientSpec().maxFramePayloadLength()).isEqualTo(1024);
            HttpClientCustomizedConfig config = (HttpClientCustomizedConfig)context.getBean(HttpClientCustomizedConfig.class);
            Assertions.assertThat((boolean)config.called.get()).isTrue();
        });
    }

    @Test
    public void verboseActuatorEnabledByDefault() {
        try (ConfigurableApplicationContext ctx = SpringApplication.run(Config.class, (String[])new String[]{"--spring.jmx.enabled=false", "--server.port=0"});){
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayControllerEndpoint.class)).hasSize(1);
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayLegacyControllerEndpoint.class)).isEmpty();
        }
    }

    @Test
    public void verboseActuatorDisabled() {
        try (ConfigurableApplicationContext ctx = SpringApplication.run(Config.class, (String[])new String[]{"--spring.jmx.enabled=false", "--server.port=0", "--spring.cloud.gateway.actuator.verbose.enabled=false"});){
            Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayLegacyControllerEndpoint.class)).hasSize(1);
        }
    }

    @Test
    public void tokenRelayBeansAreCreated() {
        ((ReactiveWebApplicationContextRunner)((ReactiveWebApplicationContextRunner)new ReactiveWebApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{ReactiveSecurityAutoConfiguration.class, ReactiveOAuth2ClientAutoConfiguration.class, GatewayReactiveOAuth2AutoConfiguration.class, GatewayAutoConfiguration.TokenRelayConfiguration.class}))).withPropertyValues(new String[]{"spring.security.oauth2.client.provider[testprovider].authorization-uri=http://localhost", "spring.security.oauth2.client.provider[testprovider].token-uri=http://localhost/token", "spring.security.oauth2.client.registration[test].provider=testprovider", "spring.security.oauth2.client.registration[test].authorization-grant-type=authorization_code", "spring.security.oauth2.client.registration[test].redirect-uri=http://localhost/redirect", "spring.security.oauth2.client.registration[test].client-id=login-client"})).run(context -> {
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ReactiveOAuth2AuthorizedClientManager.class);
            ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(TokenRelayGatewayFilterFactory.class);
        });
    }

    @Test
    public void noTokenRelayFilter() {
        Assertions.assertThatThrownBy(() -> {
            try (ConfigurableApplicationContext ctx = SpringApplication.run(RouteLocatorBuilderConfig.class, (String[])new String[]{"--spring.jmx.enabled=false", "--spring.cloud.gateway.filter.token-relay.enabled=false", "--spring.security.oauth2.client.provider[testprovider].authorization-uri=http://localhost", "--spring.security.oauth2.client.provider[testprovider].token-uri=http://localhost/token", "--spring.security.oauth2.client.registration[test].provider=testprovider", "--spring.security.oauth2.client.registration[test].authorization-grant-type=authorization_code", "--spring.security.oauth2.client.registration[test].redirect-uri=http://localhost/redirect", "--spring.security.oauth2.client.registration[test].client-id=login-client", "--server.port=0", "--spring.cloud.gateway.actuator.verbose.enabled=false"});){
                Assertions.assertThat((Object[])ctx.getBeanNamesForType(GatewayLegacyControllerEndpoint.class)).hasSize(1);
            }
        }).hasRootCauseInstanceOf(IllegalStateException.class).hasMessageContaining("No TokenRelayGatewayFilterFactory bean was found. Did you include");
    }

    @Test
    public void reactorNettyRequestUpgradeStrategyWebSocketSpecBuilderIsUniquePerRequest() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ReactorNettyRequestUpgradeStrategy strategy = new GatewayAutoConfiguration.NettyConfiguration().reactorNettyRequestUpgradeStrategy(new HttpClientProperties());
        Method buildSpec = ReactorNettyRequestUpgradeStrategy.class.getDeclaredMethod("buildSpec", String.class);
        buildSpec.setAccessible(true);
        WebsocketServerSpec spec1 = (WebsocketServerSpec)buildSpec.invoke((Object)strategy, "p1");
        WebsocketServerSpec spec2 = strategy.getWebsocketServerSpec();
        Assertions.assertThat((String)spec1.protocols()).isEqualTo("p1");
        Assertions.assertThat((String)spec2.protocols()).isNull();
    }

    @Configuration
    protected static class HttpClientCustomizedConfig {
        private final AtomicBoolean called = new AtomicBoolean();

        protected HttpClientCustomizedConfig() {
        }

        @Bean
        HttpClientCustomizer myCustomCustomizer() {
            return httpClient -> {
                this.called.compareAndSet(false, true);
                return httpClient;
            };
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class RouteLocatorBuilderConfig {
        protected RouteLocatorBuilderConfig() {
        }

        @Bean
        public RouteLocator myRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test", r -> r.alwaysTrue().filters(GatewayFilterSpec::tokenRelay).uri("http://localhost")).build();
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class Config {
        protected Config() {
        }
    }
}

