/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.Collections;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledFilter;
import org.springframework.cloud.gateway.config.conditional.OnEnabledComponent;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.mock.env.MockEnvironment;

class OnEnabledComponentTests {
    private OnEnabledComponent<Object> onEnabledComponent;
    private MockEnvironment environment;
    private ConditionContext conditionContext;

    OnEnabledComponentTests() {
    }

    @BeforeEach
    void setUp() {
        this.onEnabledComponent = this.createOnEnabledComponent("test-class");
        this.environment = new MockEnvironment();
        this.conditionContext = (ConditionContext)Mockito.mock(ConditionContext.class);
    }

    @Test
    public void shouldMatchComponent() {
        Mockito.when((Object)this.conditionContext.getEnvironment()).thenReturn((Object)this.environment);
        ConditionOutcome outcome = this.onEnabledComponent.getMatchOutcome(this.conditionContext, this.mockMetaData(EnabledComponent.class));
        Assertions.assertThat((boolean)outcome.isMatch()).isTrue();
    }

    @Test
    public void shouldNotMatchDisabledComponent() {
        String componentName = "disabled-component";
        this.onEnabledComponent = this.createOnEnabledComponent(componentName);
        Mockito.when((Object)this.conditionContext.getEnvironment()).thenReturn((Object)this.environment);
        this.environment.setProperty("spring.cloud.gateway." + componentName + ".enabled", "false");
        ConditionOutcome outcome = this.onEnabledComponent.getMatchOutcome(this.conditionContext, this.mockMetaData(DisabledComponent.class));
        Assertions.assertThat((boolean)outcome.isMatch()).isFalse();
        ((AbstractStringAssert)Assertions.assertThat((String)outcome.getMessage()).contains(new CharSequence[]{"DisabledComponent"})).contains(new CharSequence[]{"bean is not available"});
    }

    private AnnotatedTypeMetadata mockMetaData(Class<?> value) {
        AnnotatedTypeMetadata metadata = (AnnotatedTypeMetadata)Mockito.mock(AnnotatedTypeMetadata.class);
        Mockito.when((Object)metadata.getAnnotationAttributes((String)ArgumentMatchers.eq((Object)ConditionalOnEnabledFilter.class.getName()))).thenReturn(Collections.singletonMap("value", value));
        return metadata;
    }

    private OnEnabledComponent<Object> createOnEnabledComponent(final String componentName) {
        return new OnEnabledComponent<Object>(){

            protected String normalizeComponentName(Class<?> componentClass) {
                return componentName;
            }

            protected Class<?> annotationClass() {
                return ConditionalOnEnabledFilter.class;
            }

            protected Class<?> defaultValueClass() {
                return Object.class;
            }
        };
    }

    protected static class DisabledComponent {
        protected DisabledComponent() {
        }
    }

    protected static class EnabledComponent {
        protected EnabledComponent() {
        }
    }
}

