/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.cors;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class CorsTests
extends BaseWebClientTests {
    @Test
    public void testPreFlightCorsRequest() {
        ClientResponse clientResponse = (ClientResponse)this.webClient.options().uri("/abc/123/function", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Access-Control-Request-Method", new String[]{"GET"}).exchangeToMono(Mono::just).block();
        HttpHeaders asHttpHeaders = clientResponse.headers().asHttpHeaders();
        Mono bodyToMono = clientResponse.bodyToMono(String.class);
        Assertions.assertThat((String)((String)bodyToMono.block())).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)asHttpHeaders.getAccessControlAllowOrigin()).as("Missing header value in response: Access-Control-Allow-Origin", new Object[0])).isEqualTo("*");
        ((ListAssert)Assertions.assertThat((List)asHttpHeaders.getAccessControlAllowMethods()).as("Missing header value in response: Access-Control-Allow-Methods", new Object[0])).isEqualTo(Arrays.asList(HttpMethod.GET));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)clientResponse.statusCode()).as("Pre Flight call failed.", new Object[0])).isEqualTo((Object)HttpStatus.OK);
    }

    @Test
    public void testCorsRequest() {
        ResponseEntity response = (ResponseEntity)this.webClient.get().uri("/abc/123/function", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Host", new String[]{"www.path.org"}).retrieve().toEntity(String.class).block();
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((String)((String)response.getBody())).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)response.getHeaders().getAccessControlAllowOrigin()).as("Missing header value in response: Access-Control-Allow-Origin", new Object[0])).isEqualTo("*");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)response.getStatusCode()).as("CORS request failed.", new Object[0])).isEqualTo((Object)HttpStatus.OK);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

