/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.cors;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.gateway.globalcors.add-to-simple-url-handler-mapping=true"})
@DirtiesContext
@ActiveProfiles(value={"request-header-web-filter"})
public class SimpleUrlHandlerCorsTests
extends BaseWebClientTests {
    @Test
    public void testPreFlightCorsRequestNotHandledByGW() {
        ClientResponse clientResponse = (ClientResponse)this.webClient.options().uri("/abc/123/function", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Access-Control-Request-Method", new String[]{"GET"}).exchange().block();
        HttpHeaders asHttpHeaders = clientResponse.headers().asHttpHeaders();
        Mono bodyToMono = clientResponse.bodyToMono(String.class);
        Assertions.assertThat((String)((String)bodyToMono.block())).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)asHttpHeaders.getAccessControlAllowOrigin()).as("Missing header value in response: Access-Control-Allow-Origin", new Object[0])).isEqualTo("*");
        ((ListAssert)Assertions.assertThat((List)asHttpHeaders.getAccessControlAllowMethods()).as("Missing header value in response: Access-Control-Allow-Methods", new Object[0])).isEqualTo(Arrays.asList(HttpMethod.GET));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)clientResponse.statusCode()).as("Pre Flight call failed.", new Object[0])).isEqualTo((Object)HttpStatus.OK);
    }

    @Test
    public void testCorsRequestNotHandledByGW() {
        ClientResponse clientResponse = (ClientResponse)this.webClient.get().uri("/abc/123/function", new Object[0]).header("Origin", new String[]{"domain.com"}).header("Host", new String[]{"www.path.org"}).exchange().block();
        HttpHeaders asHttpHeaders = clientResponse.headers().asHttpHeaders();
        Mono bodyToMono = clientResponse.bodyToMono(String.class);
        Assertions.assertThat((String)((String)bodyToMono.block())).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)asHttpHeaders.getAccessControlAllowOrigin()).as("Missing header value in response: Access-Control-Allow-Origin", new Object[0])).isEqualTo("*");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)clientResponse.statusCode()).as("CORS request failed.", new Object[0])).isEqualTo((Object)HttpStatus.NOT_FOUND);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @AutoConfigureBefore(value={GatewayAutoConfiguration.class})
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

