/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class GatewayMetricsFilterCustomTagsTests
extends BaseWebClientTests {
    private static final String REQUEST_METRICS_NAME = "spring.cloud.gateway.requests";
    @Autowired
    private MeterRegistry meterRegistry;
    @Value(value="${test.uri}")
    private String testUri;

    @Test
    public void gatewayRequestsMeterFilterHasCustomTags() {
        this.testClient.get().uri("/headers", new Object[0]).exchange().expectStatus().isOk();
        this.assertMetricsContainsTag("outcome", HttpStatus.Series.SUCCESSFUL.name());
        this.assertMetricsContainsTag("status", HttpStatus.OK.name());
        this.assertMetricsContainsTag("httpStatusCode", String.valueOf(HttpStatus.OK.value()));
        this.assertMetricsContainsTag("httpMethod", HttpMethod.GET.toString());
        this.assertMetricsContainsTag("routeId", "default_path_to_httpbin");
        this.assertMetricsContainsTag("routeUri", this.testUri);
        this.assertMetricsContainsTag("custom1", "tag1");
        this.assertMetricsContainsTag("custom2", "tag2");
    }

    private void assertMetricsContainsTag(String tagKey, String tagValue) {
        Assertions.assertThat((long)this.meterRegistry.get(REQUEST_METRICS_NAME).tag(tagKey, tagValue).timer().count()).isEqualTo(1L);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class CustomConfig {
        @Bean
        public GatewayTagsProvider customGatewayTagsProvider() {
            return exchange -> Tags.of((String[])new String[]{"custom1", "tag1", "custom2", "tag2"});
        }
    }
}

