/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.micrometer.core.instrument.MeterRegistry;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class GatewayMetricsFilterTests
extends BaseWebClientTests {
    private static final String REQUEST_METRICS_NAME = "spring.cloud.gateway.requests";
    @Autowired
    private MeterRegistry meterRegistry;
    @Value(value="${test.uri}")
    private String testUri;

    @Test
    public void gatewayRequestsMeterFilterHasTags() {
        this.testClient.get().uri("/headers", new Object[0]).exchange().expectStatus().isOk();
        this.assertMetricsContainsTag("outcome", HttpStatus.Series.SUCCESSFUL.name());
        this.assertMetricsContainsTag("status", HttpStatus.OK.name());
        this.assertMetricsContainsTag("httpStatusCode", String.valueOf(HttpStatus.OK.value()));
        this.assertMetricsContainsTag("httpMethod", HttpMethod.GET.toString());
        this.assertMetricsContainsTag("routeId", "default_path_to_httpbin");
        this.assertMetricsContainsTag("routeUri", this.testUri);
    }

    @Test
    public void gatewayRequestsMeterFilterHasTagsForBadTargetUri() {
        this.testClient.get().uri("/badtargeturi", new Object[0]).exchange().expectStatus().is5xxServerError();
        this.assertMetricsContainsTag("outcome", HttpStatus.Series.SERVER_ERROR.name());
        this.assertMetricsContainsTag("status", HttpStatus.INTERNAL_SERVER_ERROR.name());
        this.assertMetricsContainsTag("httpStatusCode", String.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        this.assertMetricsContainsTag("httpMethod", HttpMethod.GET.toString());
        this.assertMetricsContainsTag("routeId", "default_path_to_httpbin");
        this.assertMetricsContainsTag("routeUri", this.testUri);
    }

    @Test
    public void hasMetricsForSetStatusFilter() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Host", "www.setcustomstatusmetrics.org");
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange(this.baseUri + "/headers", HttpMethod.POST, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        Assertions.assertThat((int)response.getStatusCodeValue()).isEqualTo(432);
        this.assertMetricsContainsTag("outcome", "CUSTOM");
        this.assertMetricsContainsTag("status", "432");
        this.assertMetricsContainsTag("routeId", "test_custom_http_status_metrics");
        this.assertMetricsContainsTag("routeUri", this.testUri);
        this.assertMetricsContainsTag("httpStatusCode", "432");
        this.assertMetricsContainsTag("httpMethod", HttpMethod.POST.toString());
    }

    private void assertMetricsContainsTag(String tagKey, String tagValue) {
        ((AbstractLongAssert)Assertions.assertThat((long)this.meterRegistry.get(REQUEST_METRICS_NAME).tag(tagKey, tagValue).timer().count()).as("Wrong value for metric %s: %s", new Object[]{tagKey, tagValue})).isGreaterThanOrEqualTo(1L);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @RestController
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class CustomConfig {
        @Value(value="${test.uri}")
        protected String testUri;

        @Bean
        public RouteLocator myRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_custom_http_status_metrics", r -> r.host(new String[]{"*.setcustomstatusmetrics.org"}).filters(f -> f.setStatus(432)).uri(this.testUri)).build();
        }

        @RequestMapping(value={"/httpbin/badtargeturi"})
        public String exception() {
            throw new RuntimeException("an error");
        }
    }
}

