/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(properties={"spring.cloud.gateway.httpclient.response-timeout=3s"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class NettyRoutingFilterIntegrationTests
extends BaseWebClientTests {
    @Autowired
    private ResponseDecoratingFilter responseDecorator;

    @Test
    public void responseTimeoutWorks() {
        this.testClient.get().uri("/delay/5", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT).expectBody().jsonPath("$.status", new Object[0]).isEqualTo((Object)String.valueOf(HttpStatus.GATEWAY_TIMEOUT.value())).jsonPath("$.message", new Object[0]).isEqualTo((Object)"Response took longer than timeout: PT3S");
    }

    @Test
    public void outboundHostHeaderNotOverwrittenByInbound() {
        WebTestClient client = this.testClient.mutate().baseUrl("http://127.0.0.1:" + this.port).build();
        client.get().uri("/headers", new Object[0]).exchange().expectBody().jsonPath("$.headers.host", new Object[0]).isEqualTo((Object)("localhost:" + this.port));
    }

    @Test
    public void canHandleDecoratedResponseWithNonStandardStatusValue() {
        int NON_STANDARD_STATUS = 480;
        this.responseDecorator.decorateResponseTimes(1);
        this.testClient.mutate().baseUrl("http://localhost:" + this.port).build().get().uri("/status/480", new Object[0]).exchange().expectStatus().isEqualTo(480);
    }

    @Test
    public void canHandleUndecoratedResponseWithNonStandardStatusValue() {
        int NON_STANDARD_STATUS = 480;
        this.responseDecorator.decorateResponseTimes(0);
        this.testClient.mutate().baseUrl("http://localhost:" + this.port).build().get().uri("/status/480", new Object[0]).exchange().expectStatus().isEqualTo(480);
    }

    @Test
    public void canHandleMultiplyDecoratedResponseWithNonStandardStatusValue() {
        int NON_STANDARD_STATUS = 142;
        this.responseDecorator.decorateResponseTimes(14);
        this.testClient.mutate().baseUrl("http://localhost:" + this.port).build().get().uri("/status/142", new Object[0]).exchange().expectStatus().isEqualTo(142);
    }

    @Test
    public void shouldApplyConnectTimeoutPerRoute() {
        long currentTimeMillisBeforeCall = System.currentTimeMillis();
        this.testClient.get().uri("/connect/delay/2", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR).expectBody().jsonPath("$.message", new Object[0]).value(Matchers.containsString((String)"Connection refused: localhost/127.0.0.1:32167"));
        Assertions.assertThat((long)(System.currentTimeMillis() - currentTimeMillisBeforeCall)).isCloseTo(5L, Offset.offset((Number)100L));
    }

    @Test
    public void shouldApplyResponseTimeoutPerRoute() {
        this.testClient.get().uri("/route/delay/2", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT).expectBody().jsonPath("$.status", new Object[0]).isEqualTo((Object)String.valueOf(HttpStatus.GATEWAY_TIMEOUT.value())).jsonPath("$.message", new Object[0]).isEqualTo((Object)"Response took longer than timeout: PT1S");
    }

    @Test
    public void shouldNotApplyPerRouteTimeoutWhenItIsNotConfigured() {
        this.testClient.get().uri("/delay/2", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.OK);
    }

    public static final class ResponseDecoratingFilter
    implements GlobalFilter,
    Ordered {
        int decorationIterations = 1;

        public void decorateResponseTimes(int times) {
            this.decorationIterations = times;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            ServerHttpResponse decorator = exchange.getResponse();
            for (int counter = 0; counter < this.decorationIterations; ++counter) {
                decorator = new ServerHttpResponseDecorator(decorator);
            }
            return chain.filter(exchange.mutate().response(decorator).build());
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Bean
        @Order(value=-2147483648)
        public ResponseDecoratingFilter decoratingFilter() {
            return new ResponseDecoratingFilter();
        }
    }
}

