/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class NettyRoutingFilterTests {
    @Autowired
    private ApplicationContext context;

    @Test
    @Ignore
    public void mockServerWorks() {
        WebTestClient client = WebTestClient.bindToApplicationContext((ApplicationContext)this.context).build();
        client.get().uri("/mockexample", new Object[0]).exchange().expectStatus().value(Matchers.lessThan((Comparable)Integer.valueOf(500)));
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    public static class TestConfig {
        @Bean
        public RouteLocator routes(RouteLocatorBuilder builder) {
            return builder.routes().route(p -> p.path(new String[]{"/mockexample"}).filters(f -> f.prefixPath("/httpbin")).uri("http://example.com")).build();
        }
    }
}

