/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(profiles={"request-header-web-filter"})
public class AddRequestHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void addRequestHeaderFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.addrequestheader.org"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Example", (Object)"ValueA");
        });
    }

    @Test
    public void addRequestHeaderFilterWorksMultipleValues() {
        this.testClient.get().uri("/multivalueheaders", new Object[0]).header("Host", new String[]{"www.addrequestheader.org"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Example", Arrays.asList("ValueA", "ValueB"));
        });
    }

    @Test
    public void addRequestHeaderFilterWorksJavaDsl() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.addrequestheaderjava.org"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Acme", (Object)"ValueB-www");
        });
    }

    @Test
    public void addRequestHeaderFilterMultipleValuesWorksJavaDsl() {
        this.testClient.get().uri("/multivalueheaders", new Object[0]).header("Host", new String[]{"www.addrequestheaderjava.org"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Acme", Arrays.asList("ValueB-www", "ValueC-www"));
        });
    }

    @Test
    public void toStringFormat() {
        AbstractNameValueGatewayFilterFactory.NameValueConfig config = new AbstractNameValueGatewayFilterFactory.NameValueConfig().setName("myname").setValue("myvalue");
        GatewayFilter filter = new AddRequestHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{"myvalue"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("add_request_header_java_test", r -> r.path(new String[]{"/headers"}).and().host(new String[]{"{sub}.addrequestheaderjava.org"}).filters(f -> f.prefixPath("/httpbin").addRequestHeader("X-Request-Acme", "ValueB-{sub}")).uri(this.uri)).route("add_multiple_request_header_java_test", r -> r.path(new String[]{"/multivalueheaders"}).and().host(new String[]{"{sub}.addrequestheaderjava.org"}).filters(f -> f.prefixPath("/httpbin").addRequestHeader("X-Request-Acme", "ValueB-{sub}").addRequestHeader("X-Request-Acme", "ValueC-{sub}")).uri(this.uri)).build();
        }
    }
}

