/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.PreserveHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class PreserveHostHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void preserveHostHeaderGatewayFilterFactoryWorks() {
        this.testClient.get().uri("/multivalueheaders", new Object[0]).header("Host", new String[]{"www.preservehostheader.org"}).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsKey((Object)"Host");
            List values = (List)headers.get("Host");
            Assertions.assertThat((List)values).containsExactly((Object[])new String[]{"myhost.net"});
        });
    }

    @Test
    public void toStringFormat() {
        GatewayFilter filter = new PreserveHostHeaderGatewayFilterFactory().apply();
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"PreserveHostHeader"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_preserve_host_header", r -> r.order(-1).host(new String[]{"**.preservehostheader.org"}).filters(f -> f.prefixPath("/httpbin").preserveHostHeader().setRequestHeader("Host", "myhost.net")).uri(this.uri)).build();
        }
    }
}

