/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveRequestParameterGatewayFilterFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RemoveRequestParameterGatewayFilterFactoryTests {
    private ServerWebExchange exchange;
    private GatewayFilterChain filterChain;
    private ArgumentCaptor<ServerWebExchange> captor;

    @Before
    public void setUp() {
        this.filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        this.captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)this.filterChain.filter((ServerWebExchange)this.captor.capture())).thenReturn((Object)Mono.empty());
    }

    @Test
    public void removeRequestParameterFilterWorks() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).queryParam("foo", new Object[]{Collections.singletonList("bar")}).build();
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName("foo");
        GatewayFilter filter = new RemoveRequestParameterGatewayFilterFactory().apply(config);
        filter.filter(this.exchange, this.filterChain);
        ServerHttpRequest actualRequest = ((ServerWebExchange)this.captor.getValue()).getRequest();
        Assertions.assertThat((Map)actualRequest.getQueryParams()).doesNotContainKey((Object)"foo");
    }

    @Test
    public void removeRequestParameterFilterWorksWhenParamIsNotPresentInRequest() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).build();
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName("foo");
        GatewayFilter filter = new RemoveRequestParameterGatewayFilterFactory().apply(config);
        filter.filter(this.exchange, this.filterChain);
        ServerHttpRequest actualRequest = ((ServerWebExchange)this.captor.getValue()).getRequest();
        Assertions.assertThat((Map)actualRequest.getQueryParams()).doesNotContainKey((Object)"foo");
    }

    @Test
    public void removeRequestParameterFilterShouldOnlyRemoveSpecifiedParam() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).queryParam("foo", new Object[]{"bar"}).queryParam("abc", new Object[]{"xyz"}).build();
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName("foo");
        GatewayFilter filter = new RemoveRequestParameterGatewayFilterFactory().apply(config);
        filter.filter(this.exchange, this.filterChain);
        ServerHttpRequest actualRequest = ((ServerWebExchange)this.captor.getValue()).getRequest();
        Assertions.assertThat((Map)actualRequest.getQueryParams()).doesNotContainKey((Object)"foo");
        Assertions.assertThat((Map)actualRequest.getQueryParams()).containsEntry((Object)"abc", Collections.singletonList("xyz"));
    }

    @Test
    public void removeRequestParameterFilterShouldHandleRemainingParamsWhichRequiringEncoding() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost", (Object[])new Object[0]).queryParam("foo", new Object[]{"bar"}).queryParam("aaa", new Object[]{"abc xyz"}).queryParam("bbb", new Object[]{"[xyz"}).queryParam("ccc", new Object[]{",xyz"}).build();
        this.exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName("foo");
        GatewayFilter filter = new RemoveRequestParameterGatewayFilterFactory().apply(config);
        filter.filter(this.exchange, this.filterChain);
        ServerHttpRequest actualRequest = ((ServerWebExchange)this.captor.getValue()).getRequest();
        Assertions.assertThat((Map)actualRequest.getQueryParams()).doesNotContainKey((Object)"foo");
        Assertions.assertThat((Map)actualRequest.getQueryParams()).containsEntry((Object)"aaa", Collections.singletonList("abc xyz"));
        Assertions.assertThat((Map)actualRequest.getQueryParams()).containsEntry((Object)"bbb", Collections.singletonList("[xyz"));
        Assertions.assertThat((Map)actualRequest.getQueryParams()).containsEntry((Object)"ccc", Collections.singletonList(",xyz"));
    }
}

