/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class RequestHeaderToRequestUriGatewayFilterFactoryIntegrationTests
extends BaseWebClientTests {
    @LocalServerPort
    int port;

    @Test
    @Ignore
    public void changeUriWorkWithProperties() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"www.changeuri.org"}).header("X-CF-Forwarded-Url", new String[]{"http://localhost:" + this.port + "/actuator/health"}).exchange().expectBody(JsonNode.class).consumeWith(r -> Assertions.assertThat((boolean)((JsonNode)r.getResponseBody()).has("status")).isTrue());
    }

    @Test
    @Ignore
    public void changeUriWorkWithDsl() {
        this.testClient.get().uri("/", new Object[0]).header("Host", new String[]{"www.changeuri.org"}).header("X-Next-Url", new String[]{"http://localhost:" + this.port + "/actuator/health"}).exchange().expectBody(JsonNode.class).consumeWith(r -> Assertions.assertThat((boolean)((JsonNode)r.getResponseBody()).has("status")).isTrue());
    }

    @Test
    public void changeUriWorkWithCustomLogic() {
        this.testClient.get().uri(b -> b.path("/").queryParam("url", new Object[]{"http://localhost:" + this.port + "/actuator/health"}).build(new Object[0])).header("Host", new String[]{"www.changeuri.org"}).exchange().expectBody(JsonNode.class).consumeWith(r -> Assertions.assertThat((boolean)((JsonNode)r.getResponseBody()).has("status")).isTrue());
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Bean
        public RouteLocator routeLocator(RouteLocatorBuilder builder) {
            return builder.routes().route(r -> r.host(new String[]{"**.changeuri.org"}).and().header("X-Next-Url").filters(f -> f.requestHeaderToRequestUri("X-Next-Url")).uri("https://example.com")).route(r -> r.host(new String[]{"**.changeuri.org"}).and().query("url").filters(f -> f.changeRequestUri(e -> Optional.of(URI.create((String)e.getRequest().getQueryParams().getFirst((Object)"url"))))).uri("https://example.com")).build();
        }
    }
}

