/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.RequestRateLimiterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.ratelimit.KeyResolver;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpStatus;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class RequestRateLimiterGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Autowired
    @Qualifier(value="resolver2")
    KeyResolver resolver2;
    @Autowired
    private ApplicationContext context;
    @MockBean
    private RateLimiter rateLimiter;
    @MockBean
    private GatewayFilterChain filterChain;

    @Test
    public void allowedWorks() {
        this.assertFilterFactory(null, "allowedkey", true, HttpStatus.OK);
    }

    @Test
    public void notAllowedWorks() {
        this.assertFilterFactory(this.resolver2, "notallowedkey", false, HttpStatus.TOO_MANY_REQUESTS);
    }

    @Test
    public void emptyKeyDenied() {
        this.assertFilterFactory(exchange -> Mono.empty(), null, true, HttpStatus.FORBIDDEN);
    }

    @Test
    public void emptyKeyAllowed() {
        this.assertFilterFactory(exchange -> Mono.empty(), null, true, HttpStatus.OK, false);
    }

    private void assertFilterFactory(KeyResolver keyResolver, String key, boolean allowed, HttpStatus expectedStatus) {
        this.assertFilterFactory(keyResolver, key, allowed, expectedStatus, null);
    }

    private void assertFilterFactory(KeyResolver keyResolver, String key, boolean allowed, HttpStatus expectedStatus, Boolean denyEmptyKey) {
        String tokensRemaining = allowed ? "1" : "0";
        Map<String, String> headers = Collections.singletonMap("X-Tokens-Remaining", tokensRemaining);
        if (key != null) {
            Mockito.when((Object)this.rateLimiter.isAllowed("myroute", key)).thenReturn((Object)Mono.just((Object)new RateLimiter.Response(allowed, headers)));
        }
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"/", (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getResponse().setStatusCode(HttpStatus.OK);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("myroute")).predicate(ex -> true).uri("http://localhost")).build());
        Mockito.when((Object)this.filterChain.filter((ServerWebExchange)exchange)).thenReturn((Object)Mono.empty());
        RequestRateLimiterGatewayFilterFactory factory = (RequestRateLimiterGatewayFilterFactory)this.context.getBean(RequestRateLimiterGatewayFilterFactory.class);
        if (denyEmptyKey != null) {
            factory.setDenyEmptyKey(denyEmptyKey.booleanValue());
        }
        GatewayFilter filter = factory.apply(config -> {
            config.setRouteId("myroute");
            config.setKeyResolver(keyResolver);
        });
        Mono response = filter.filter((ServerWebExchange)exchange, this.filterChain);
        response.subscribe(aVoid -> {
            Assertions.assertThat((Comparable)exchange.getResponse().getStatusCode()).isEqualTo((Object)expectedStatus);
            Assertions.assertThat((Map)exchange.getResponse().getHeaders()).containsEntry((Object)"X-Tokens-Remaining", Collections.singletonList(tokensRemaining));
        });
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Bean
        @Primary
        KeyResolver resolver1() {
            return exchange -> Mono.just((Object)"allowedkey");
        }

        @Bean
        KeyResolver resolver2() {
            return exchange -> Mono.just((Object)"notallowedkey");
        }
    }
}

