/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicIntegerAssert;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.system.OutputCaptureRule;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.gateway.httpclient.connect-timeout=500", "spring.cloud.gateway.httpclient.response-timeout=2s", "logging.level.org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactory=TRACE"})
@DirtiesContext
@ActiveProfiles(value={"retrytests"})
public class RetryGatewayFilterFactoryIntegrationTests
extends BaseWebClientTests {
    @Rule
    public final OutputCaptureRule capture = new OutputCaptureRule();

    @Test
    public void retryFilterGet() {
        this.testClient.get().uri("/retry?key=get", new Object[0]).exchange().expectStatus().isOk().expectBody(String.class).isEqualTo((Object)"3");
    }

    @Test
    public void retryFilterFailure() {
        this.testClient.mutate().responseTimeout(Duration.ofSeconds(10L)).build().get().uri("/retryalwaysfail?key=getjavafailure&count=4", new Object[0]).header("Host", new String[]{"www.retryjava.org"}).exchange().expectStatus().is5xxServerError().expectBody(String.class).consumeWith(result -> Assertions.assertThat((String)((String)result.getResponseBody())).contains(new CharSequence[]{"permanently broken"}));
    }

    @Test
    public void retryWithBackoff() {
        this.testClient.get().uri("/retry?key=retry-with-backoff&count=3", new Object[0]).header("Host", new String[]{"www.retrywithbackoff.org"}).exchange().expectStatus().isOk().expectHeader().value("X-Retry-Count", CoreMatchers.equalTo((Object)"3"));
    }

    @Test
    public void retryFilterGetJavaDsl() {
        this.testClient.get().uri("/retry?key=getjava&count=2", new Object[0]).header("Host", new String[]{"www.retryjava.org"}).exchange().expectStatus().isOk().expectBody(String.class).isEqualTo((Object)"2");
    }

    @Test
    public void retryFilterPost() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/retrypost?key=postconfig&expectedbody=HelloConfig", new Object[0])).header("Host", new String[]{"www.retrypostconfig.org"})).bodyValue((Object)"HelloConfig").exchange().expectStatus().isOk().expectBody(String.class).isEqualTo((Object)"3");
        Assertions.assertThat((String)this.capture.toString()).contains(new CharSequence[]{"disposing response connection before next iteration"});
    }

    @Test
    public void retryFilterPostJavaDsl() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/retrypost?key=post&expectedbody=Hello", new Object[0])).header("Host", new String[]{"www.retryjava.org"})).bodyValue((Object)"Hello").exchange().expectStatus().isOk().expectBody(String.class).isEqualTo((Object)"3");
    }

    @Test
    public void retryFilterPostOneTime() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/retrypost?key=retryFilterPostOneTime&expectedbody=HelloGateway&count=1", new Object[0])).header("Host", new String[]{"www.retrypostonceconfig.org"})).bodyValue((Object)"HelloGateway").exchange().expectStatus().isOk();
        Assertions.assertThat((String)this.capture.toString()).contains(new CharSequence[]{"setting new iteration in attr 0"});
        Assertions.assertThat((String)this.capture.toString()).doesNotContain(new CharSequence[]{"setting new iteration in attr 1"});
    }

    @Test
    public void retriesSleepyRequest() throws Exception {
        this.testClient.mutate().responseTimeout(Duration.ofSeconds(10L)).build().get().uri("/sleep?key=sleepyRequest&millis=3000", new Object[0]).header("Host", new String[]{"www.retryjava.org"}).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT);
        ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)TestConfig.map.get("sleepyRequest")).isNotNull()).hasValue(3);
    }

    @Test
    public void shouldNotRetryWhenSleepyRequestPost() throws Exception {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.mutate().responseTimeout(Duration.ofSeconds(10L)).build().post().uri("/sleep?key=notRetriesSleepyRequestPost&millis=3000", new Object[0])).header("Host", new String[]{"www.retry-only-get.org"})).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT);
        ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)TestConfig.map.get("notRetriesSleepyRequestPost")).isNotNull()).hasValue(1);
    }

    @Test
    public void shouldNotRetryWhenSleepyRequestPostWithBody() throws Exception {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.mutate().responseTimeout(Duration.ofSeconds(10L)).build().post().uri("/sleep?key=notRetriesSleepyRequestPostWithBody&millis=3000", new Object[0])).header("Host", new String[]{"www.retry-only-get.org"})).bodyValue((Object)"retry sleepy post with body").exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT);
        ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)TestConfig.map.get("notRetriesSleepyRequestPostWithBody")).isNotNull()).hasValue(1);
    }

    @Test
    public void shouldRetryWhenSleepyRequestGet() throws Exception {
        this.testClient.mutate().responseTimeout(Duration.ofSeconds(10L)).build().get().uri("/sleep?key=sleepyRequestGet&millis=3000", new Object[0]).header("Host", new String[]{"www.retry-only-get.org"}).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT);
        ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)TestConfig.map.get("sleepyRequestGet")).isNotNull()).hasValue(3);
    }

    @Test
    public void retryFilterLoadBalancedWithMultipleServers() {
        String host = "www.retrywithloadbalancer.org";
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{host}).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(res -> {
            Map body = (Map)res.getResponseBody();
            Assertions.assertThat((Map)body).isNotNull();
            Map headers = (Map)body.get("headers");
            Assertions.assertThat((Map)headers).containsEntry((Object)"X-Forwarded-Host", (Object)host);
        });
    }

    @Test
    public void toStringFormat() {
        RetryGatewayFilterFactory.RetryConfig config = new RetryGatewayFilterFactory.RetryConfig();
        config.setRetries(4);
        config.setMethods(new HttpMethod[]{HttpMethod.GET});
        config.setSeries(new HttpStatus.Series[]{HttpStatus.Series.SERVER_ERROR});
        config.setExceptions(new Class[]{IOException.class});
        GatewayFilter filter = new RetryGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"4"})).contains(new CharSequence[]{"[GET]"})).contains(new CharSequence[]{"[SERVER_ERROR]"})).contains(new CharSequence[]{"[IOException]"});
    }

    protected static class TestBadLoadBalancerConfig {
        @LocalServerPort
        protected int port = 0;

        protected TestBadLoadBalancerConfig() {
        }

        @Bean
        public ServiceInstanceListSupplier staticServiceInstanceListSupplier() {
            return ServiceInstanceListSuppliers.from((String)"badservice2", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("doesnotexist1", "badservice2", "localhost.domain.doesnot.exist", this.port, true), new DefaultServiceInstance("badservice2-1", "badservice2", "localhost", this.port, false)});
        }
    }

    @RestController
    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @LoadBalancerClient(name="badservice2", configuration={TestBadLoadBalancerConfig.class})
    public static class TestConfig {
        Log log = LogFactory.getLog(this.getClass());
        static ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();
        @Value(value="${test.uri}")
        private String uri;

        @RequestMapping(value={"/httpbin/sleep"})
        public Mono<ResponseEntity<String>> sleep(@RequestParam(value="key") String key, @RequestParam(value="millis") long millisToSleep) {
            AtomicInteger num = this.getCount(key);
            int retryCount = num.incrementAndGet();
            this.log.warn((Object)("Retry count: " + retryCount));
            return Mono.delay((Duration)Duration.ofMillis(millisToSleep)).thenReturn((Object)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).header("X-Retry-Count", new String[]{String.valueOf(retryCount)})).body((Object)("slept " + millisToSleep + " ms")));
        }

        @RequestMapping(value={"/httpbin/retryalwaysfail"})
        public ResponseEntity<String> retryalwaysfail(@RequestParam(value="key") String key, @RequestParam(name="count", defaultValue="3") int count) {
            AtomicInteger num = this.getCount(key);
            int i = num.incrementAndGet();
            this.log.warn((Object)("Retry count: " + i));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).header("X-Retry-Count", new String[]{String.valueOf(i)})).body((Object)"permanently broken");
        }

        @RequestMapping(value={"/httpbin/retrypost"})
        public ResponseEntity<String> retrypost(@RequestParam(value="key") String key, @RequestParam(name="count", defaultValue="3") int count, @RequestParam(value="expectedbody") String expectedbody, @RequestBody String body) {
            ResponseEntity<String> response = this.retry(key, count);
            if (!expectedbody.equals(body)) {
                AtomicInteger num = this.getCount(key);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).header("X-Retry-Count", new String[]{String.valueOf(num)})).body((Object)("body did not match on try" + num));
            }
            return response;
        }

        @RequestMapping(value={"/httpbin/retry"})
        public ResponseEntity<String> retry(@RequestParam(value="key") String key, @RequestParam(name="count", defaultValue="3") int count) {
            AtomicInteger num = this.getCount(key);
            int i = num.incrementAndGet();
            this.log.warn((Object)("Retry count: " + i));
            String body = String.valueOf(i);
            if (i < count) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).header("X-Retry-Count", new String[]{body})).body((Object)"temporarily broken");
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).header("X-Retry-Count", new String[]{body})).body((Object)body);
        }

        AtomicInteger getCount(String key) {
            return map.computeIfAbsent(key, s -> new AtomicInteger());
        }

        @Bean
        public RouteLocator hystrixRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("retry_java", r -> r.host(new String[]{"**.retryjava.org"}).filters(f -> f.prefixPath("/httpbin").retry(config -> config.setRetries(2).setMethods(new HttpMethod[]{HttpMethod.POST, HttpMethod.GET}))).uri(this.uri)).route("retry_only_get", r -> r.host(new String[]{"**.retry-only-get.org"}).filters(f -> f.prefixPath("/httpbin").retry(config -> config.setRetries(2).setMethods(new HttpMethod[]{HttpMethod.GET}))).uri(this.uri)).route("retry_with_backoff", r -> r.host(new String[]{"**.retrywithbackoff.org"}).filters(f -> f.prefixPath("/httpbin").retry(config -> config.setRetries(2).setBackoff(Duration.ofMillis(100L), null, 2, true))).uri(this.uri)).route("retry_with_loadbalancer", r -> r.host(new String[]{"**.retrywithloadbalancer.org"}).filters(f -> f.prefixPath("/httpbin").retry(config -> config.setRetries(2))).uri("lb://badservice2")).build();
        }
    }
}

