/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.reactivestreams.Publisher;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersProperties;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class SecureHeadersGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void secureHeadersFilterWorks() {
        Mono result = this.webClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.secureheaders.org"}).exchangeToMono(Mono::just);
        SecureHeadersProperties defaults = new SecureHeadersProperties();
        StepVerifier.create((Publisher)result).consumeNextWith(response -> {
            TestUtils.assertStatus(response, HttpStatus.OK);
            HttpHeaders httpHeaders = response.headers().asHttpHeaders();
            Assertions.assertThat((String)httpHeaders.getFirst("X-Xss-Protection")).isEqualTo(defaults.getXssProtectionHeader());
            Assertions.assertThat((String)httpHeaders.getFirst("Strict-Transport-Security")).isEqualTo(defaults.getStrictTransportSecurity());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Frame-Options")).isEqualTo(defaults.getFrameOptions());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Content-Type-Options")).isEqualTo(defaults.getContentTypeOptions());
            Assertions.assertThat((String)httpHeaders.getFirst("Referrer-Policy")).isEqualTo(defaults.getReferrerPolicy());
            Assertions.assertThat((String)httpHeaders.getFirst("Content-Security-Policy")).isEqualTo(defaults.getContentSecurityPolicy());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Download-Options")).isEqualTo(defaults.getDownloadOptions());
            Assertions.assertThat((String)httpHeaders.getFirst("X-Permitted-Cross-Domain-Policies")).isEqualTo(defaults.getPermittedCrossDomainPolicies());
        }).expectComplete().verify(DURATION);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

