/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.junit.Test;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public abstract class SpringCloudCircuitBreakerFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void cbFilterWorks() {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.sccbsuccess.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"sccb_success_test"});
    }

    @Test
    public void cbFilterTimesout() {
        this.testClient.get().uri("/delay/3", new Object[0]).header("Host", new String[]{"www.sccbtimeout.org"}).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT).expectBody().jsonPath("$.status", new Object[0]).isEqualTo((Object)String.valueOf(HttpStatus.GATEWAY_TIMEOUT.value()));
    }

    @Test
    public void timeoutFromWebClient() {
        this.testClient.get().uri("/delay/10", new Object[0]).header("Host", new String[]{"www.circuitbreakerresponsestall.org"}).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT);
    }

    @Test
    public void filterFallback() {
        this.testClient.get().uri("/delay/3?a=b", new Object[0]).header("Host", new String[]{"www.circuitbreakerfallback.org"}).exchange().expectStatus().isOk().expectBody().json("{\"from\":\"circuitbreakerfallbackcontroller\"}");
    }

    @Test
    public void filterWorksJavaDsl() {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.circuitbreakerjava.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"circuitbreaker_java"});
    }

    @Test
    public void filterFallbackJavaDsl() {
        this.testClient.get().uri("/delay/3", new Object[0]).header("Host", new String[]{"www.circuitbreakerjava.org"}).exchange().expectStatus().isOk().expectBody().json("{\"from\":\"circuitbreakerfallbackcontroller2\"}");
    }

    @Test
    public void filterConnectFailure() {
        this.testClient.get().uri("/delay/3", new Object[0]).header("Host", new String[]{"www.circuitbreakerconnectfail.org"}).exchange().expectStatus().is5xxServerError();
    }

    @Test
    public void filterErrorPage() {
        this.testClient.get().uri("/delay/3", new Object[0]).header("Host", new String[]{"www.circuitbreakerconnectfail.org"}).accept(new MediaType[]{MediaType.APPLICATION_JSON}).exchange().expectStatus().is5xxServerError().expectBody().jsonPath("$.status", new Object[0]).isEqualTo((Object)500).jsonPath("$.message", new Object[0]).isNotEmpty().jsonPath("$.error", new Object[0]).isEqualTo((Object)"Internal Server Error");
    }

    @Test
    public void filterFallbackForward() {
        this.testClient.get().uri("/delay/3?a=c", new Object[0]).header("Host", new String[]{"www.circuitbreakerforward.org"}).exchange().expectStatus().isOk().expectBody().json("{\"from\":\"circuitbreakerfallbackcontroller3\"}");
    }

    @Test
    public void filterStatusCodeFallback() {
        this.testClient.get().uri("/status/500", new Object[0]).header("Host", new String[]{"www.circuitbreakerstatuscode.org"}).exchange().expectStatus().isOk().expectBody().json("{\"from\":\"statusCodeFallbackController\"}");
        this.testClient.get().uri("/status/404", new Object[0]).header("Host", new String[]{"www.circuitbreakerstatuscode.org"}).exchange().expectStatus().isOk().expectBody().json("{\"from\":\"statusCodeFallbackController\"}");
        this.testClient.get().uri("/status/200", new Object[0]).header("Host", new String[]{"www.circuitbreakerstatuscode.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"circuitbreaker_fallback_test_statuscode"});
    }
}

