/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.RetryingTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyRequestBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.gateway.httpclient.ssl.handshake-timeout=1ms", "spring.main.allow-bean-definition-overriding=true"})
@DirtiesContext
@ActiveProfiles(value={"single-cert-ssl"})
public class ModifyRequestBodyGatewayFilterFactorySslTimeoutTests
extends BaseWebClientTests {
    @Autowired
    AtomicInteger releaseCount;

    @Override
    @BeforeEach
    public void setup() {
        try {
            SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            HttpClient httpClient = HttpClient.create().secure(ssl -> ssl.sslContext(sslContext));
            this.setup((ClientHttpConnector)new ReactorClientHttpConnector(httpClient), "https://localhost:" + this.port);
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void modifyRequestBodySSLTimeout() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.modifyrequestbodyssltimeout.org"})).header("Content-Type", new String[]{"application/xml"})).body(BodyInserters.fromValue((Object)"request")).exchange().expectStatus().isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR).expectBody().jsonPath("message", new Object[0]).isEqualTo((Object)"handshake timed out after 1ms");
    }

    @RetryingTest(value=3)
    public void modifyRequestBodyRelease() {
        this.releaseCount.set(0);
        for (int i = 0; i < 10; ++i) {
            ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.modifyrequestbodyssltimeout.org"})).header("Content-Type", new String[]{"application/xml"})).body(BodyInserters.fromValue((Object)"request")).exchange().expectStatus().isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR);
            long l = PlatformDependent.usedDirectMemory();
        }
        Assertions.assertThat((AtomicInteger)this.releaseCount).hasValue(10);
    }

    @Test
    public void modifyRequestBodyHappenedError() {
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).header("Host", new String[]{"www.modifyrequestbodyexception.org"})).header("Content-Type", new String[]{"application/xml"})).body(BodyInserters.fromValue((Object)"request")).exchange().expectStatus().isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR).expectBody().jsonPath("message", new Object[0]).isEqualTo((Object)"modify body exception");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration(proxyBeanMethods=false)
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        @DependsOn(value={"testModifyRequestBodyGatewayFilterFactory"})
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_modify_request_body_ssl_timeout", r -> r.order(-1).host(new String[]{"**.modifyrequestbodyssltimeout.org"}).filters(f -> f.modifyRequestBody(String.class, String.class, "application/json", (serverWebExchange, aVoid) -> {
                byte[] largeBody = new byte[0xA00000];
                return Mono.just((Object)new String(largeBody));
            })).uri(this.uri)).route("test_modify_request_body_exception", r -> r.order(-1).host(new String[]{"**.modifyrequestbodyexception.org"}).filters(f -> f.modifyRequestBody(String.class, String.class, "application/json", (serverWebExchange, body) -> Mono.error((Throwable)new Exception("modify body exception")))).uri(this.uri)).build();
        }

        @Bean
        public AtomicInteger count() {
            return new AtomicInteger();
        }

        @Bean
        @Primary
        public ModifyRequestBodyGatewayFilterFactory testModifyRequestBodyGatewayFilterFactory(ServerCodecConfigurer codecConfigurer, final AtomicInteger count) {
            return new ModifyRequestBodyGatewayFilterFactory(codecConfigurer.getReaders()){

                protected Mono<Void> release(ServerWebExchange exchange, CachedBodyOutputMessage outputMessage, Throwable throwable) {
                    if (outputMessage.isCached()) {
                        count.incrementAndGet();
                    }
                    return super.release(exchange, outputMessage, throwable);
                }
            };
        }
    }
}

