/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class ModifyResponseBodyGatewayFilterFactoryGzipTests
extends BaseWebClientTests {
    @Test
    public void testModificationOfResponseBody() {
        URI uri = UriComponentsBuilder.fromUriString((String)(this.baseUri + "/gzip")).build(true).toUri();
        this.testClient.get().uri(uri).header("Host", new String[]{"www.modifyresponsebodyjava.org"}).accept(new MediaType[]{MediaType.APPLICATION_JSON}).exchange().expectBody().json("{\"length\":25,\"value\":\"\\\"httpbin compatible home\\\"\"}");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("modify_response_java_test_gzip", r -> r.path(new String[]{"/gzip"}).and().host(new String[]{"www.modifyresponsebodyjava.org"}).filters(f -> f.modifyResponseBody(String.class, Map.class, (webExchange, originalResponse) -> {
                HashMap<String, Object> modifiedResponse = new HashMap<String, Object>();
                modifiedResponse.put("value", originalResponse);
                modifiedResponse.put("length", originalResponse.length());
                return Mono.just(modifiedResponse);
            })).uri(this.uri)).build();
        }
    }
}

