/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.server.ServerWebExchange;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class HttpStatusInResponseHeadersFilterTests
extends BaseWebClientTests {
    @Test
    public void statusCodeAvailableInResponseHttpHeadersFilter() {
        this.testClient.get().uri("/get", new Object[0]).exchange().expectStatus().isOk();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Bean
        public HttpHeadersFilter checkStatusFilter() {
            return new HttpHeadersFilter(){

                public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
                    HttpStatus statusCode = exchange.getResponse().getStatusCode();
                    Assertions.assertThat((Comparable)statusCode).isEqualTo((Object)HttpStatus.OK);
                    return input;
                }

                public boolean supports(HttpHeadersFilter.Type type) {
                    return type == HttpHeadersFilter.Type.RESPONSE;
                }
            };
        }
    }
}

