/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT, properties={"server.port=62175"})
@DirtiesContext
public class NonStandardHeadersInResponseTests
extends BaseWebClientTests {
    public static final String CONTENT_TYPE_IMAGE = "image";

    @Test
    public void nonStandardHeadersInResponse() {
        URI uri = UriComponentsBuilder.fromUriString((String)(this.baseUri + "/get-image")).build(true).toUri();
        String contentType = (String)WebClient.builder().baseUrl(this.baseUri).build().get().uri(uri).exchangeToMono(Mono::just).map(clientResponse -> clientResponse.headers().asHttpHeaders().getFirst("Content-Type")).block();
        Assertions.assertThat((String)contentType).isEqualTo(CONTENT_TYPE_IMAGE);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        private static final Log log = LogFactory.getLog(TestConfig.class);
        @Value(value="${test.uri}")
        String uri;
        @Value(value="${server.port}")
        int port;

        @Bean
        @Order(value=5001)
        public GlobalFilter addNonStandardHeaderFilter() {
            return (exchange, chain) -> {
                log.info((Object)"addNonStandardHeaderFilter pre phase");
                return chain.filter(exchange).then(Mono.fromRunnable(() -> {
                    log.info((Object)"addNonStandardHeaderFilter post phase");
                    exchange.getResponse().getHeaders().set("Content-Type", NonStandardHeadersInResponseTests.CONTENT_TYPE_IMAGE);
                }));
            };
        }

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("non_standard_header_route", r -> r.path(new String[]{"/get-image/**"}).filters(f -> f.addRequestHeader("Host", "www.addrequestparameter.org").stripPrefix(1)).uri("http://localhost:" + this.port + "/get")).route("internal_route", r -> r.path(new String[]{"/get/**"}).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

