/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.ratelimit.RedisRateLimiter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@DirtiesContext
@ActiveProfiles(value={"redis-rate-limiter-default-config"})
public class RedisRateLimiterDefaultFilterConfigTests {
    @Autowired
    private RedisRateLimiter rateLimiter;
    @Autowired
    private RouteLocator routeLocator;

    @Before
    public void init() {
        this.routeLocator.getRoutes().collectList().block();
    }

    @Test
    public void redisRateConfiguredFromEnvironmentDefaultFilters() {
        String routeId = "redis_rate_limiter_config_default_test";
        RedisRateLimiter.Config config = this.rateLimiter.loadConfiguration(routeId);
        this.assertConfigAndRoute(routeId, 70, 80, 10, config);
    }

    private void assertConfigAndRoute(String key, int replenishRate, int burstCapacity, int requestedTokens, RedisRateLimiter.Config config) {
        Assertions.assertThat((Object)config).isNotNull();
        Assertions.assertThat((int)config.getReplenishRate()).isEqualTo(replenishRate);
        Assertions.assertThat((int)config.getBurstCapacity()).isEqualTo(burstCapacity);
        Assertions.assertThat((int)config.getRequestedTokens()).isEqualTo(requestedTokens);
        Route route = (Route)this.routeLocator.getRoutes().filter(r -> r.getId().equals(key)).next().block();
        Assertions.assertThat((Object)route).isNotNull();
        Assertions.assertThat((List)route.getFilters()).isNotEmpty();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    public static class TestConfig {
    }
}

