/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.SocketUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"management.server.port=${test.port}"})
@DirtiesContext
public class RoutePredicateHandlerMappingIntegrationTests
extends BaseWebClientTests {
    private static int managementPort;

    @BeforeClass
    public static void beforeClass() {
        managementPort = SocketUtils.findAvailableTcpPort();
        System.setProperty("test.port", String.valueOf(managementPort));
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("test.port");
    }

    @Test
    public void requestsToManagementPortReturn404() {
        this.testClient.mutate().baseUrl("http://localhost:" + managementPort).build().get().uri("/get", new Object[0]).exchange().expectStatus().isNotFound();
    }

    @Test
    public void andNotWorksWithMissingParameter() {
        this.testClient.get().uri("/andnotquery", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"notsupplied");
    }

    @Test
    public void andNotWorksWithParameter() {
        this.testClient.get().uri("/andnotquery?myquery=shouldnotsee", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"hasquery");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @RestController
    public static class TestConfig {
        @Value(value="${test.uri:http://httpbin.org:80}")
        String uri;

        @GetMapping(value={"/httpbin/andnotquery"})
        String andnotquery(@RequestParam(name="myquery", defaultValue="notsupplied") String myquery) {
            return myquery;
        }

        @GetMapping(value={"/httpbin/hasquery"})
        String hasquery() {
            return "hasquery";
        }

        @Bean
        RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("and_not_missing_myquery", r -> r.path(new String[]{"/andnotquery"}).and().not(p -> p.query("myquery")).filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).route("and_not_has_myquery", r -> r.path(new String[]{"/andnotquery"}).and().query("myquery").filters(f -> f.setPath("/httpbin/hasquery")).uri(this.uri)).build();
        }
    }
}

