/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.SocketUtils;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT)
@DirtiesContext
public class RoutePredicateHandlerMappingSameManagementPortIntegrationTests
extends BaseWebClientTests {
    private static int samePort;

    @BeforeClass
    public static void beforeClass() {
        samePort = SocketUtils.findAvailableTcpPort();
        System.setProperty("server.port", String.valueOf(samePort));
        System.setProperty("management.server.port", String.valueOf(samePort));
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("server.port");
        System.clearProperty("management.server.port");
    }

    @Test
    public void requestsToGatewaySucceed() {
        this.testClient.mutate().baseUrl("http://localhost:" + samePort).build().get().uri("/get", new Object[0]).exchange().expectStatus().isOk();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

