/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.system.OutputCaptureRule;
import org.springframework.cloud.gateway.handler.predicate.QueryRoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class QueryRoutePredicateFactoryTests
extends BaseWebClientTests {
    @Rule
    public OutputCaptureRule output = new OutputCaptureRule();

    @Test
    public void noQueryParamWorks() {
        this.testClient.get().uri("/get", new Object[0]).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
        this.output.expect(Matchers.not((Matcher)Matchers.containsString((String)"Error applying predicate for route: foo_query_param")));
    }

    @Test
    public void queryParamWorks() {
        this.testClient.get().uri("/get?foo=bar", new Object[0]).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"foo_query_param"});
    }

    @Test
    public void emptyQueryParamWorks() {
        this.testClient.get().uri("/get?foo", new Object[0]).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"default_path_to_httpbin"});
        this.output.expect(Matchers.not((Matcher)Matchers.containsString((String)"Error applying predicate for route: foo_query_param")));
    }

    @Test
    public void toStringFormat() {
        QueryRoutePredicateFactory.Config config = new QueryRoutePredicateFactory.Config();
        config.setParam("myparam");
        config.setRegexp("myregexp");
        Predicate predicate = new QueryRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Query: param=myparam regexp=myregexp"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        private String uri;

        @Bean
        RouteLocator queryRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("foo_query_param", r -> r.query("foo", "bar").filters(f -> f.prefixPath("/httpbin")).uri(this.uri)).build();
        }
    }
}

