/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Random;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.WeightCalculatorWebFilter;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"weights-404"})
@DirtiesContext
public class WeightRoutePredicateFactoryYaml404Tests
extends BaseWebClientTests {
    @Autowired
    private WeightCalculatorWebFilter filter;

    private static Random getRandom(double value) {
        Random random = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)value);
        return random;
    }

    @Test
    public void weightsFromYamlNot404() {
        this.filter.setRandom(WeightRoutePredicateFactoryYaml404Tests.getRandom(0.5));
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.weight4041.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"weight_first_404_test_1"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        public TestConfig(WeightCalculatorWebFilter filter) {
            Random random = WeightRoutePredicateFactoryYaml404Tests.getRandom(0.4);
            filter.setRandom(random);
        }
    }
}

