/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.CachingRouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class CachingRouteDefinitionLocatorTests {
    @Test
    public void getRouteDefinitionsWorks() {
        RouteDefinition routeDef1 = this.routeDef(1);
        RouteDefinition routeDef2 = this.routeDef(2);
        CachingRouteDefinitionLocator locator = new CachingRouteDefinitionLocator(() -> Flux.just((Object[])new RouteDefinition[]{routeDef2, routeDef1}));
        List routes = (List)locator.getRouteDefinitions().collectList().block();
        Assertions.assertThat((List)routes).containsExactlyInAnyOrder((Object[])new RouteDefinition[]{routeDef1, routeDef2});
    }

    @Test
    public void refreshWorks() {
        RouteDefinition routeDef1 = this.routeDef(1);
        RouteDefinition routeDef2 = this.routeDef(2);
        CachingRouteDefinitionLocator locator = new CachingRouteDefinitionLocator((RouteDefinitionLocator)new StubRouteDefinitionLocator(Flux.just((Object)routeDef2), Flux.just((Object[])new RouteDefinition[]{routeDef1, routeDef2})));
        List routes = (List)locator.getRouteDefinitions().collectList().block();
        Assertions.assertThat((List)routes).containsExactlyInAnyOrder((Object[])new RouteDefinition[]{routeDef2});
        routes = (List)locator.refresh().collectList().block();
        Assertions.assertThat((List)routes).containsExactlyInAnyOrder((Object[])new RouteDefinition[]{routeDef1, routeDef2});
    }

    @Test
    public void cacheIsNotClearedOnEvent() {
        RouteDefinition routeDef1 = this.routeDef(1);
        RouteDefinition routeDef2 = this.routeDef(2);
        CountDownLatch latch = new CountDownLatch(1);
        CachingRouteDefinitionLocator locator = new CachingRouteDefinitionLocator((RouteDefinitionLocator)new StubRouteDefinitionLocator(Flux.just((Object)routeDef1), Flux.defer(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            return Flux.just((Object[])new RouteDefinition[]{routeDef1, routeDef2});
        }).subscribeOn(Schedulers.single())));
        List routes = (List)locator.getRouteDefinitions().collectList().block();
        Assertions.assertThat((List)routes).containsExactlyInAnyOrder((Object[])new RouteDefinition[]{routeDef1});
        locator.onApplicationEvent(new RefreshRoutesEvent((Object)this));
        routes = (List)locator.getRouteDefinitions().collectList().block();
        Assertions.assertThat((List)routes).containsExactlyInAnyOrder((Object[])new RouteDefinition[]{routeDef1});
        latch.countDown();
    }

    @Test
    public void cacheIsRefreshedInTheBackgroundOnEvent() {
        RouteDefinition routeDef1 = this.routeDef(1);
        RouteDefinition routeDef2 = this.routeDef(2);
        CachingRouteDefinitionLocator locator = new CachingRouteDefinitionLocator((RouteDefinitionLocator)new StubRouteDefinitionLocator(Flux.just((Object)routeDef1), Flux.defer(() -> Flux.just((Object[])new RouteDefinition[]{routeDef1, routeDef2}))));
        List routes = (List)locator.getRouteDefinitions().collectList().block();
        Assertions.assertThat((List)routes).containsExactlyInAnyOrder((Object[])new RouteDefinition[]{routeDef1});
        locator.onApplicationEvent(new RefreshRoutesEvent((Object)this));
        List updatedRoutes = (List)locator.getRouteDefinitions().collectList().block();
        Assertions.assertThat((List)updatedRoutes).containsExactlyInAnyOrder((Object[])new RouteDefinition[]{routeDef1, routeDef2});
    }

    RouteDefinition routeDef(int id) {
        RouteDefinition def = new RouteDefinition();
        def.setId(String.valueOf(id));
        def.setUri(URI.create("http://localhost/" + id));
        def.setOrder(id);
        return def;
    }

    private static final class StubRouteDefinitionLocator
    implements RouteDefinitionLocator {
        private final Flux<RouteDefinition> first;
        private final Flux<RouteDefinition> second;
        int i;

        private StubRouteDefinitionLocator(Flux<RouteDefinition> first, Flux<RouteDefinition> second) {
            this.first = first;
            this.second = second;
            this.i = 0;
        }

        public Flux<RouteDefinition> getRouteDefinitions() {
            if (this.i++ == 0) {
                return this.first;
            }
            return this.second;
        }
    }
}

