/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.context.annotation.Bean;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest
public class ShortcutConfigurableTests {
    @Autowired
    BeanFactory beanFactory;
    private SpelExpressionParser parser;

    @Test
    public void testNormalizeDefaultTypeWithSpel() {
        this.parser = new SpelExpressionParser();
        ShortcutConfigurable shortcutConfigurable = new ShortcutConfigurable(){

            public List<String> shortcutFieldOrder() {
                return Arrays.asList("bean", "arg1");
            }
        };
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("bean", "#{@foo}");
        args.put("arg1", "val1");
        Map map = ShortcutConfigurable.ShortcutType.DEFAULT.normalize(args, shortcutConfigurable, this.parser, this.beanFactory);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)map).isNotNull()).containsEntry((Object)"bean", (Object)42)).containsEntry((Object)"arg1", (Object)"val1");
    }

    @Test
    public void testNormalizeGatherListTypeWithSpel() {
        this.parser = new SpelExpressionParser();
        ShortcutConfigurable shortcutConfigurable = new ShortcutConfigurable(){

            public List<String> shortcutFieldOrder() {
                return Arrays.asList("values");
            }

            public ShortcutConfigurable.ShortcutType shortcutType() {
                return ShortcutConfigurable.ShortcutType.GATHER_LIST;
            }
        };
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("1", "#{@foo}");
        args.put("2", "val1");
        args.put("3", "val2");
        Map map = ShortcutConfigurable.ShortcutType.GATHER_LIST.normalize(args, shortcutConfigurable, this.parser, this.beanFactory);
        ((MapAssert)Assertions.assertThat((Map)map).isNotNull()).containsKey((Object)"values");
        Assertions.assertThat((List)((List)map.get("values"))).containsExactly(new Object[]{42, "val1", "val2"});
    }

    @Test
    public void testNormalizeGatherListTailFlagFlagExists() {
        this.assertListTailFlag(true);
    }

    @Test
    public void testNormalizeGatherListTailFlagFlagMissing() {
        this.assertListTailFlag(false);
    }

    private void assertListTailFlag(boolean hasTailFlag) {
        this.parser = new SpelExpressionParser();
        ShortcutConfigurable shortcutConfigurable = new ShortcutConfigurable(){

            public List<String> shortcutFieldOrder() {
                return Arrays.asList("values", "flag");
            }

            public ShortcutConfigurable.ShortcutType shortcutType() {
                return ShortcutConfigurable.ShortcutType.GATHER_LIST_TAIL_FLAG;
            }
        };
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("1", "val0");
        args.put("2", "val1");
        args.put("3", "val2");
        if (hasTailFlag) {
            args.put("4", "false");
        }
        Map map = ShortcutConfigurable.ShortcutType.GATHER_LIST_TAIL_FLAG.normalize(args, shortcutConfigurable, this.parser, this.beanFactory);
        ((MapAssert)Assertions.assertThat((Map)map).isNotNull()).containsKey((Object)"values");
        Assertions.assertThat((List)((List)map.get("values"))).containsExactly(new Object[]{"val0", "val1", "val2"});
        if (hasTailFlag) {
            Assertions.assertThat(map.get("flag")).isEqualTo((Object)"false");
        } else {
            Assertions.assertThat((Map)map).doesNotContainKeys((Object[])new String[]{"flag"});
        }
    }

    @SpringBootConfiguration
    protected static class TestConfig {
        protected TestConfig() {
        }

        @Bean
        public Integer foo() {
            return 42;
        }
    }
}

