/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class FormIntegrationTests
extends BaseWebClientTests {
    public static final MediaType FORM_URL_ENCODED_CONTENT_TYPE = new MediaType(MediaType.APPLICATION_FORM_URLENCODED, StandardCharsets.UTF_8);

    @Test
    public void formUrlencodedWorks() {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"foo", (Object)"bar");
        formData.add((Object)"baz", (Object)"bam");
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).contentType(FORM_URL_ENCODED_CONTENT_TYPE).body((BodyInserter)BodyInserters.fromFormData((MultiValueMap)formData)).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map map = (Map)result.getResponseBody();
            Map<String, Object> form = TestUtils.getMap(map, "form");
            Assertions.assertThat(form).containsEntry((Object)"foo", (Object)"bar");
            Assertions.assertThat(form).containsEntry((Object)"baz", (Object)"bam");
        });
    }

    @Test
    public void multipartFormDataWorksWebClient() {
        MultiValueMap<String, HttpEntity<?>> formData = this.createMultipartData();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("/post", new Object[0])).contentType(MediaType.MULTIPART_FORM_DATA).bodyValue(formData).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> this.assertMultipartData((Map)result.getResponseBody()));
    }

    @Test
    public void multipartFormDataWorksRestTemplate() {
        MultiValueMap<String, HttpEntity<?>> formData = this.createMultipartData();
        TestRestTemplate rest = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
        ResponseEntity response = rest.postForEntity(this.baseUri + "/post", formData, Map.class, new Object[0]);
        Assertions.assertThat((Comparable)response.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        this.assertMultipartData((Map)response.getBody());
    }

    private MultiValueMap<String, HttpEntity<?>> createMultipartData() {
        ClassPathResource part = new ClassPathResource("1x1.png");
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        builder.part("imgpart", (Object)part, MediaType.IMAGE_PNG);
        return builder.build();
    }

    private void assertMultipartData(Map responseBody) {
        Map<String, Object> files = TestUtils.getMap(responseBody, "files");
        Assertions.assertThat(files).containsKey((Object)"imgpart");
        String file = (String)files.get("imgpart");
        ((AbstractStringAssert)Assertions.assertThat((String)file).startsWith((CharSequence)"data:")).contains(new CharSequence[]{";base64,"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

