/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import java.util.Collections;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class ForwardTests {
    @LocalServerPort
    protected int port = 0;
    protected WebTestClient client;

    @Before
    public void setup() {
        String baseUri = "http://localhost:" + this.port;
        this.client = WebTestClient.bindToServer().baseUrl(baseUri).build();
    }

    @Test
    public void forwardWorks() {
        this.client.get().uri("/localcontroller", new Object[0]).header("Host", new String[]{"www.forward.org"}).exchange().expectStatus().isOk().expectBody().json("{\"from\":\"localcontroller\"}");
    }

    @Test
    public void forwardWithCorrectPath() {
        this.client.get().uri("/foo", new Object[0]).header("Host", new String[]{"www.forward.org"}).exchange().expectStatus().isOk().expectBody().json("{\"from\":\"localcontroller\"}");
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @RestController
    @Import(value={PermitAllSecurityConfiguration.class})
    public static class TestConfig {
        @RequestMapping(value={"/httpbin/localcontroller"})
        public Map<String, String> localController() {
            return Collections.singletonMap("from", "localcontroller");
        }
    }
}

