/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class HttpStatusTests
extends BaseWebClientTests {
    public static void main(String[] args) {
        new SpringApplication(new Class[]{TestConfig.class}).run(args);
    }

    @Test
    public void notFoundResponseWorks() {
        this.testClient.get().uri("/status/404", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.NOT_FOUND).expectBody(String.class).isEqualTo((Object)"Failed with 404");
    }

    @Test
    public void nonStandardCodeWorks() {
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getForEntity(this.baseUri + "/status/432", String.class, new Object[0]);
        Assertions.assertThat((int)response.getStatusCodeValue()).isEqualTo(432);
        Assertions.assertThat((String)((String)response.getBody())).isEqualTo("Failed with 432");
    }

    @Test
    public void serverErrorResponseWorks() {
        this.testClient.get().uri("/status/500", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR).expectBody(String.class).isEqualTo((Object)"Failed with 500");
    }

    @Test
    public void normalErrorPageWorks() {
        this.testClient.get().uri("/exception", new Object[0]).exchange().expectStatus().isEqualTo(HttpStatus.INTERNAL_SERVER_ERROR).expectBody(Map.class).consumeWith(result -> Assertions.assertThat((Map)((Map)result.getResponseBody())).hasSizeGreaterThanOrEqualTo(5).containsKeys(new Object[]{"timestamp", "path", "status", "error", "message"}));
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @RestController
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @RequestMapping(value={"/httpbin/exception"})
        public String exception() {
            throw new RuntimeException("an error");
        }
    }
}

