/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test.sse;

import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.cloud.gateway.test.support.HttpServer;
import org.springframework.cloud.gateway.test.support.ReactorHttpServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Flux;
import reactor.test.StepVerifier;

public class SseIntegrationTests {
    public HttpServer server;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected int serverPort;
    private AnnotationConfigApplicationContext wac;
    private WebClient webClient;
    private ConfigurableApplicationContext gatewayContext;
    private int gatewayPort;

    public static Flux<Long> interval(Duration period, int count) {
        return Flux.interval((Duration)period).take((long)count).onBackpressureBuffer(2);
    }

    @Before
    public void setup() throws Exception {
        this.server = new ReactorHttpServer();
        this.server.setHandler(this.createHttpHandler());
        this.server.afterPropertiesSet();
        this.server.start();
        this.serverPort = this.server.getPort();
        this.logger.info((Object)("SSE Port: " + this.serverPort));
        this.gatewayContext = new SpringApplicationBuilder(new Class[]{GatewayConfig.class}).properties(new String[]{"sse.server.port:" + this.serverPort, "server.port=0", "spring.jmx.enabled=false"}).run(new String[0]);
        ConfigurableEnvironment env = (ConfigurableEnvironment)this.gatewayContext.getBean(ConfigurableEnvironment.class);
        this.gatewayPort = Integer.valueOf(env.getProperty("local.server.port"));
        this.webClient = WebClient.create((String)("http://localhost:" + this.gatewayPort + "/sse"));
        this.logger.info((Object)("Gateway Port: " + this.gatewayPort));
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
        this.serverPort = 0;
        this.gatewayPort = 0;
        this.gatewayContext.close();
        this.wac.close();
    }

    private HttpHandler createHttpHandler() {
        this.wac = new AnnotationConfigApplicationContext();
        this.wac.register(new Class[]{TestConfiguration.class});
        this.wac.refresh();
        return WebHttpHandlerBuilder.webHandler((WebHandler)new DispatcherHandler((ApplicationContext)this.wac)).build();
    }

    @Test
    public void sseAsString() {
        Flux result = this.webClient.get().uri("/string", new Object[0]).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux(String.class);
        StepVerifier.create((Publisher)result).expectNext((Object)"foo 0").expectNext((Object)"foo 1").thenCancel().verify(Duration.ofSeconds(5L));
    }

    @Test
    public void sseAsPerson() {
        Flux result = this.webClient.get().uri("/person", new Object[0]).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux(Person.class);
        StepVerifier.create((Publisher)result).expectNext((Object)new Person("foo 0")).expectNext((Object)new Person("foo 1")).thenCancel().verify(Duration.ofSeconds(5L));
    }

    @Test
    public void sseAsEvent() {
        ResolvableType type = ResolvableType.forClassWithGenerics(ServerSentEvent.class, (Class[])new Class[]{String.class});
        Flux result = this.webClient.get().uri("/event", new Object[0]).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux((ParameterizedTypeReference)new ParameterizedTypeReference<ServerSentEvent<String>>(){});
        StepVerifier.create((Publisher)result).consumeNextWith(event -> {
            Assertions.assertThat((String)event.id()).isEqualTo("0");
            Assertions.assertThat((String)((String)event.data())).isEqualTo("foo");
            Assertions.assertThat((String)event.comment()).isEqualTo("bar");
            Assertions.assertThat((String)event.event()).isNull();
            Assertions.assertThat((Duration)event.retry()).isNull();
        }).consumeNextWith(event -> {
            Assertions.assertThat((String)event.id()).isEqualTo("1");
            Assertions.assertThat((String)((String)event.data())).isEqualTo("foo");
            Assertions.assertThat((String)event.comment()).isEqualTo("bar");
            Assertions.assertThat((String)event.event()).isNull();
            Assertions.assertThat((Duration)event.retry()).isNull();
        }).thenCancel().verify(Duration.ofSeconds(5L));
    }

    @Test
    public void sseAsEventWithoutAcceptHeader() {
        Flux result = this.webClient.get().uri("/event", new Object[0]).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux((ParameterizedTypeReference)new ParameterizedTypeReference<ServerSentEvent<String>>(){});
        StepVerifier.create((Publisher)result).consumeNextWith(event -> {
            Assertions.assertThat((String)event.id()).isEqualTo("0");
            Assertions.assertThat((String)((String)event.data())).isEqualTo("foo");
            Assertions.assertThat((String)event.comment()).isEqualTo("bar");
            Assertions.assertThat((String)event.event()).isNull();
            Assertions.assertThat((Duration)event.retry()).isNull();
        }).consumeNextWith(event -> {
            Assertions.assertThat((String)event.id()).isEqualTo("1");
            Assertions.assertThat((String)((String)event.data())).isEqualTo("foo");
            Assertions.assertThat((String)event.comment()).isEqualTo("bar");
            Assertions.assertThat((String)event.event()).isNull();
            Assertions.assertThat((Duration)event.retry()).isNull();
        }).thenCancel().verify(Duration.ofSeconds(5L));
    }

    private static class Person {
        private String name;

        Person() {
        }

        Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return !(this.name == null ? person.name != null : !this.name.equals(person.name));
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public String toString() {
            return "Person{name='" + this.name + '\'' + '}';
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    protected static class GatewayConfig {
        @Value(value="${sse.server.port}")
        private int port;

        protected GatewayConfig() {
        }

        @Bean
        public RouteLocator sseRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("sse_route", r -> r.alwaysTrue().uri("http://localhost:" + this.port)).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableWebFlux
    static class TestConfiguration {
        TestConfiguration() {
        }

        @Bean
        public SseController sseController() {
            return new SseController();
        }
    }

    @RestController
    static class SseController {
        private static final Flux<Long> INTERVAL = SseIntegrationTests.interval(Duration.ofMillis(100L), 50);

        SseController() {
        }

        @RequestMapping(value={"/sse/string"})
        Flux<String> string() {
            return INTERVAL.map(l -> "foo " + l);
        }

        @RequestMapping(value={"/sse/person"})
        Flux<Person> person() {
            return INTERVAL.map(l -> new Person("foo " + l));
        }

        @RequestMapping(value={"/sse/event"})
        Flux<ServerSentEvent<String>> sse() {
            return INTERVAL.map(l -> ServerSentEvent.builder((Object)"foo").id(Long.toString(l)).comment("bar").build());
        }
    }
}

