/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.cloud.gateway.test.ssl.SingleCertSSLTests;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.ResourceUtils;
import reactor.netty.http.client.HttpClient;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(value={"client-auth-ssl"})
public class ClientCertAuthSSLTests
extends SingleCertSSLTests {
    @Value(value="${spring.cloud.gateway.httpclient.ssl.key-store}")
    private String keyStore;
    @Value(value="${spring.cloud.gateway.httpclient.ssl.key-store-password}")
    private String keyStorePassword;
    @Value(value="${spring.cloud.gateway.httpclient.ssl.key-password}")
    private String keyPassword;

    @Override
    @Before
    public void setup() throws Exception {
        char[] keyPasswordCharArray;
        KeyStore store = KeyStore.getInstance("JKS");
        try {
            URL url = ResourceUtils.getURL((String)this.keyStore);
            store.load(url.openStream(), this.keyStorePassword != null ? this.keyStorePassword.toCharArray() : null);
        }
        catch (Exception e) {
            throw new WebServerException("Could not load key store ' " + this.keyStore + "'", (Throwable)e);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] cArray = keyPasswordCharArray = this.keyPassword != null ? this.keyPassword.toCharArray() : null;
        if (keyPasswordCharArray == null && this.keyStorePassword != null) {
            keyPasswordCharArray = this.keyStorePassword.toCharArray();
        }
        keyManagerFactory.init(store, keyPasswordCharArray);
        try {
            SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(keyManagerFactory).build();
            HttpClient httpClient = HttpClient.create().secure(ssl -> ssl.sslContext(sslContext));
            this.setup((ClientHttpConnector)new ReactorClientHttpConnector(httpClient), "https://localhost:" + this.port);
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Test
    public void testSslTrust() {
        this.testClient.get().uri("/ssltrust", new Object[0]).exchange().expectStatus().is2xxSuccessful();
    }
}

