/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test.ssl;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.ssl.SingleCertSSLTests;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.JsonPathAssertions;
import org.springframework.test.web.reactive.server.WebTestClient;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.gateway.httpclient.ssl.handshake-timeout=1ms"})
@DirtiesContext
@ActiveProfiles(value={"ssl"})
public class SSLHandshakeTimeoutTests
extends SingleCertSSLTests {
    @Override
    @Test
    public void testSslTrust() {
        WebTestClient.ResponseSpec responseSpec = this.testClient.get().uri("/ssltrust", new Object[0]).exchange();
        responseSpec.expectStatus().is5xxServerError();
        JsonPathAssertions jsonPath = responseSpec.expectBody().jsonPath("message", new Object[0]);
        jsonPath.isEqualTo((Object)"handshake timed out after 1ms");
    }
}

