/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.cloud.gateway.test.support.HttpServer;
import org.springframework.cloud.gateway.test.support.ReactorHttpServer;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.server.upgrade.ReactorNettyRequestUpgradeStrategy;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.ReplayProcessor;

public class WebSocketIntegrationTests {
    private static final Log logger = LogFactory.getLog(WebSocketIntegrationTests.class);
    protected int serverPort;
    private WebSocketClient client;
    private HttpServer server;
    private ConfigurableApplicationContext gatewayContext;
    private int gatewayPort;

    private static Mono<Void> doSend(WebSocketSession session, Publisher<WebSocketMessage> output) {
        return session.send(output);
    }

    @Before
    public void setup() throws Exception {
        this.client = new ReactorNettyWebSocketClient();
        this.server = new ReactorHttpServer();
        this.server.setHandler(this.createHttpHandler());
        this.server.afterPropertiesSet();
        this.server.start();
        this.serverPort = this.server.getPort();
        if (this.client instanceof Lifecycle) {
            ((Lifecycle)this.client).start();
        }
        this.gatewayContext = new SpringApplicationBuilder(new Class[]{GatewayConfig.class}).properties(new String[]{"ws.server.port:" + this.serverPort, "server.port=0", "spring.jmx.enabled=false"}).run(new String[0]);
        ConfigurableEnvironment env = (ConfigurableEnvironment)this.gatewayContext.getBean(ConfigurableEnvironment.class);
        this.gatewayPort = Integer.valueOf(env.getProperty("local.server.port"));
    }

    @After
    public void stop() throws Exception {
        if (this.client instanceof Lifecycle) {
            ((Lifecycle)this.client).stop();
        }
        this.server.stop();
        if (this.gatewayContext != null) {
            this.gatewayContext.stop();
        }
    }

    private HttpHandler createHttpHandler() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.register(new Class[]{WebSocketTestConfig.class});
        context.refresh();
        return WebHttpHandlerBuilder.applicationContext((ApplicationContext)context).build();
    }

    protected URI getUrl(String path) throws URISyntaxException {
        return new URI("ws://localhost:" + this.gatewayPort + path);
    }

    protected URI getHttpUrl(String path) throws URISyntaxException {
        return new URI("http://localhost:" + this.gatewayPort + path);
    }

    @Test
    public void echo() throws Exception {
        int count = 100;
        Flux input = Flux.range((int)1, (int)count).map(index -> "msg-" + index);
        ReplayProcessor output = ReplayProcessor.create((int)count);
        this.client.execute(this.getUrl("/echo"), session -> {
            logger.debug((Object)"Starting to send messages");
            return ((ReplayProcessor)session.send((Publisher)input.doOnNext(s -> logger.debug((Object)("outbound " + s))).map(s -> session.textMessage(s))).thenMany((Publisher)session.receive().take((long)count).map(WebSocketMessage::getPayloadAsText)).subscribeWith((Subscriber)output)).doOnNext(s -> logger.debug((Object)("inbound " + s))).then().doOnSuccess(aVoid -> logger.debug((Object)"Done with success")).doOnError(ex -> logger.debug((Object)("Done with " + (ex != null ? ex.getMessage() : "error"))));
        }).block(Duration.ofMillis(5000L));
        Assertions.assertThat((List)((List)output.collectList().block(Duration.ofMillis(5000L)))).isEqualTo(input.collectList().block(Duration.ofMillis(5000L)));
    }

    @Test
    public void echoForHttp() throws Exception {
        int count = 100;
        Flux input = Flux.range((int)1, (int)count).map(index -> "msg-" + index);
        ReplayProcessor output = ReplayProcessor.create((int)count);
        this.client.execute(this.getHttpUrl("/echoForHttp"), session -> {
            logger.debug((Object)"Starting to send messages");
            return ((ReplayProcessor)session.send((Publisher)input.doOnNext(s -> logger.debug((Object)("outbound " + s))).map(s -> session.textMessage(s))).thenMany((Publisher)session.receive().take((long)count).map(WebSocketMessage::getPayloadAsText)).subscribeWith((Subscriber)output)).doOnNext(s -> logger.debug((Object)("inbound " + s))).then().doOnSuccess(aVoid -> logger.debug((Object)"Done with success")).doOnError(ex -> logger.debug((Object)("Done with " + (ex != null ? ex.getMessage() : "error"))));
        }).block(Duration.ofMillis(5000L));
        Assertions.assertThat((List)((List)output.collectList().block(Duration.ofMillis(5000L)))).isEqualTo(input.collectList().block(Duration.ofMillis(5000L)));
    }

    @Test
    @Ignore
    public void subProtocol() throws Exception {
        final String protocol = "echo-v1";
        final String protocol2 = "echo-v2";
        final AtomicReference infoRef = new AtomicReference();
        final MonoProcessor output = MonoProcessor.create();
        this.client.execute(this.getUrl("/sub-protocol"), new WebSocketHandler(){

            public List<String> getSubProtocols() {
                return Arrays.asList(protocol, protocol2);
            }

            public Mono<Void> handle(WebSocketSession session) {
                infoRef.set(session.getHandshakeInfo());
                return ((MonoProcessor)session.receive().map(WebSocketMessage::getPayloadAsText).subscribeWith((Subscriber)output)).then();
            }
        }).block(Duration.ofMillis(5000L));
        HandshakeInfo info = (HandshakeInfo)infoRef.get();
        Assertions.assertThat((String)info.getHeaders().getFirst("Upgrade")).isEqualToIgnoringCase((CharSequence)"websocket");
        Assertions.assertThat((String)info.getHeaders().getFirst("Sec-WebSocket-Protocol")).isEqualTo(protocol);
        ((AbstractStringAssert)Assertions.assertThat((String)info.getSubProtocol()).as("Wrong protocol accepted", new Object[0])).isEqualTo(protocol);
        ((ObjectAssert)Assertions.assertThat((Object)output.block(Duration.ofSeconds(5L))).as("Wrong protocol detected on the server side", new Object[0])).isEqualTo((Object)protocol);
    }

    @Test
    @Ignore
    public void customHeader() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.add("my-header", "my-value");
        MonoProcessor output = MonoProcessor.create();
        this.client.execute(this.getUrl("/custom-header"), headers, session -> ((MonoProcessor)session.receive().map(WebSocketMessage::getPayloadAsText).subscribeWith((Subscriber)output)).then()).block(Duration.ofMillis(5000L));
        Assertions.assertThat((Object)output.block(Duration.ofMillis(5000L))).isEqualTo((Object)"my-header:my-value");
    }

    @Test
    public void sessionClosing() throws Exception {
        this.client.execute(this.getUrl("/close"), session -> {
            logger.debug((Object)"Starting..");
            return session.receive().doOnNext(s -> logger.debug((Object)("inbound " + s))).then().doFinally(signalType -> logger.debug((Object)("Completed with: " + signalType)));
        }).block(Duration.ofMillis(5000L));
    }

    public static class LocalLoadBalancerClientConfiguration {
        @Value(value="${ws.server.port}")
        private int wsPort;

        @Bean
        public ServiceInstanceListSupplier staticServiceInstanceListSupplier(Environment env) {
            return ServiceInstanceListSuppliers.from((String)"wsservice", (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("wsservice-1", "wsservice", "localhost", this.wsPort, false)});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    @LoadBalancerClient(name="wsservice", configuration={LocalLoadBalancerClientConfiguration.class})
    protected static class GatewayConfig {
        protected GatewayConfig() {
        }

        @Bean
        public RouteLocator wsRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route(r -> r.path(new String[]{"/echoForHttp"}).uri("lb://wsservice")).route(r -> r.alwaysTrue().uri("lb:ws://wsservice")).build();
        }
    }

    private static class SessionClosingHandler
    implements WebSocketHandler {
        private SessionClosingHandler() {
        }

        public Mono<Void> handle(WebSocketSession session) {
            return Flux.never().mergeWith((Publisher)session.close(CloseStatus.GOING_AWAY)).then();
        }
    }

    private static class CustomHeaderHandler
    implements WebSocketHandler {
        private CustomHeaderHandler() {
        }

        public Mono<Void> handle(WebSocketSession session) {
            HttpHeaders headers = session.getHandshakeInfo().getHeaders();
            if (!headers.containsKey((Object)"my-header")) {
                return Mono.error((Throwable)new IllegalStateException("Missing my-header"));
            }
            String payload = "my-header:" + headers.getFirst("my-header");
            WebSocketMessage message = session.textMessage(payload);
            return WebSocketIntegrationTests.doSend(session, (Publisher<WebSocketMessage>)((Publisher)Mono.just((Object)message)));
        }
    }

    private static class SubProtocolWebSocketHandler
    implements WebSocketHandler {
        private SubProtocolWebSocketHandler() {
        }

        public List<String> getSubProtocols() {
            return Arrays.asList("echo-v1", "echo-v2");
        }

        public Mono<Void> handle(WebSocketSession session) {
            String protocol = session.getHandshakeInfo().getSubProtocol();
            if (!StringUtils.hasText((String)protocol)) {
                return Mono.error((Throwable)new IllegalStateException("Missing protocol"));
            }
            List protocols = session.getHandshakeInfo().getHeaders().get((Object)"Sec-WebSocket-Protocol");
            Assertions.assertThat((List)protocols).contains((Object[])new String[]{"echo-v1,echo-v2"});
            WebSocketMessage message = session.textMessage(protocol);
            return WebSocketIntegrationTests.doSend(session, (Publisher<WebSocketMessage>)((Publisher)Mono.just((Object)message)));
        }
    }

    private static class EchoWebSocketHandler
    implements WebSocketHandler {
        private EchoWebSocketHandler() {
        }

        public Mono<Void> handle(WebSocketSession session) {
            return session.send((Publisher)session.receive().doOnNext(WebSocketMessage::retain));
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class WebSocketTestConfig {
        WebSocketTestConfig() {
        }

        @Bean
        public DispatcherHandler webHandler() {
            return new DispatcherHandler();
        }

        @Bean
        public WebSocketHandlerAdapter handlerAdapter() {
            return new WebSocketHandlerAdapter(this.webSocketService());
        }

        @Bean
        public WebSocketService webSocketService() {
            return new HandshakeWebSocketService(this.getUpgradeStrategy());
        }

        protected RequestUpgradeStrategy getUpgradeStrategy() {
            return new ReactorNettyRequestUpgradeStrategy();
        }

        @Bean
        public HandlerMapping handlerMapping() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("/echo", new EchoWebSocketHandler());
            map.put("/echoForHttp", new EchoWebSocketHandler());
            map.put("/sub-protocol", new SubProtocolWebSocketHandler());
            map.put("/custom-header", new CustomHeaderHandler());
            map.put("/close", new SessionClosingHandler());
            SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
            mapping.setUrlMap(map);
            return mapping;
        }
    }
}

