/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.config.conditional.OnEnabledFilter;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.DedupeResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.FallbackHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.MapRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerResilience4JFilterFactory;

class OnEnabledFilterTests {
    private OnEnabledFilter onEnabledFilter;

    OnEnabledFilterTests() {
    }

    @BeforeEach
    void setUp() {
        this.onEnabledFilter = new OnEnabledFilter();
    }

    @Test
    void shouldNormalizeFiltersNames() {
        List<Class> predicates = Arrays.asList(AddRequestHeaderGatewayFilterFactory.class, DedupeResponseHeaderGatewayFilterFactory.class, FallbackHeadersGatewayFilterFactory.class, MapRequestHeaderGatewayFilterFactory.class, SpringCloudCircuitBreakerResilience4JFilterFactory.class);
        List resultNames = predicates.stream().map(arg_0 -> ((OnEnabledFilter)this.onEnabledFilter).normalizeComponentName(arg_0)).collect(Collectors.toList());
        List expectedNames = Stream.of("add-request-header", "dedupe-response-header", "fallback-headers", "map-request-header", "circuit-breaker").map(s -> "filter." + s).collect(Collectors.toList());
        Assertions.assertThat(resultNames).isEqualTo(expectedNames);
    }
}

