/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.util.internal.ThreadLocalRandom;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.event.WeightDefinedEvent;
import org.springframework.cloud.gateway.filter.WeightCalculatorWebFilter;
import org.springframework.cloud.gateway.support.WeightConfig;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"weights-concurrent"})
@DirtiesContext
public class WeightCalculatorWebFilterConcurrentTests {
    @Value(value="${test.concurrent.execution.timeInSeconds:5}")
    private int maxTestTimeSeconds;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private WeightCalculatorWebFilter weightCalculatorWebFilter;
    private ExecutorService executorService;
    private long startTime;

    @Before
    public void setUp() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.startTime = System.currentTimeMillis();
    }

    @After
    public void teardown() {
        this.executorService.shutdown();
    }

    @Test
    @Ignore
    public void WeightCalculatorWebFilter_threadSafeTest() {
        this.generateEvents();
        ServerWebExchange serverWebExchangeMock = (ServerWebExchange)Mockito.mock(ServerWebExchange.class);
        WebFilterChain emptyWebFilterChain = serverWebExchange -> Mono.empty();
        while (this.isContinue()) {
            this.weightCalculatorWebFilter.filter(serverWebExchangeMock, emptyWebFilterChain);
        }
    }

    private boolean isContinue() {
        return System.currentTimeMillis() - this.startTime < TimeUnit.SECONDS.toMillis(this.maxTestTimeSeconds);
    }

    private void generateEvents() {
        this.executorService.execute(() -> {
            while (this.isContinue()) {
                this.eventPublisher.publishEvent((ApplicationEvent)this.createWeightDefinedEvent());
            }
        });
    }

    private WeightDefinedEvent createWeightDefinedEvent() {
        int weight = ThreadLocalRandom.current().nextInt() & Integer.MAX_VALUE;
        WeightConfig config = new WeightConfig("group_1", UUID.randomUUID().toString(), weight);
        return new WeightDefinedEvent(new Object(), config);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class CustomConfig {
    }
}

