/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.MapRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(profiles={"request-map-header-web-filter"})
class MapRequestHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    MapRequestHeaderGatewayFilterFactoryTests() {
    }

    @Test
    void mapRequestHeaderFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.maprequestheader.org"}).header("a", new String[]{"tome"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Example", (Object)"tome");
        });
    }

    @Test
    void mapRequestHeaderFilterWorksJavaDsl() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.maprequestheaderjava.org"}).header("b", new String[]{"tome"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"X-Request-Example-Java", (Object)"tome");
        });
    }

    @Test
    void mapRequestHeaderWithMultiValueFilterWorks() {
        this.testClient.get().uri("/multivalueheaders", new Object[0]).header("Host", new String[]{"www.maprequestheader.org"}).header("a", new String[]{"tome", "toyou"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsKey((Object)"X-Request-Example");
            List values = (List)headers.get("X-Request-Example");
            Assertions.assertThat((List)values).contains((Object[])new String[]{"tome", "toyou"});
        });
    }

    @Test
    void mapRequestHeaderWithNullValueFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.maprequestheader.org"}).header("a", new String[]{null}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).doesNotContainKey((Object)"X-Request-Example");
        });
    }

    @Test
    void mapRequestHeaderWhenInputHeaderDoesNotExist() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.maprequestheader.org"}).exchange().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).doesNotContainKey((Object)"X-Request-Example");
        });
    }

    @Test
    void toStringFormat() {
        MapRequestHeaderGatewayFilterFactory.Config config = new MapRequestHeaderGatewayFilterFactory.Config().setFromHeader("myfromheader").setToHeader("mytoheader");
        GatewayFilter filter = new MapRequestHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myfromheader"})).contains(new CharSequence[]{"mytoheader"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        TestConfig() {
        }

        @Bean
        RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("map_request_header_java_test", r -> r.path(new String[]{"/headers"}).and().host(new String[]{"**.maprequestheaderjava.org"}).filters(f -> f.prefixPath("/httpbin").mapRequestHeader("b", "X-Request-Example-Java")).uri(this.uri)).build();
        }
    }
}

