/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.LinkedHashSet;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.RewritePathGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpMethod;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RewritePathGatewayFilterFactoryTests {
    @Test
    public void rewritePathFilterWorks() {
        this.testRewriteFilter("/foo", "/baz", "/foo/bar", "/baz/bar");
    }

    @Test
    public void rewriteEncodedPathFilterWorks() {
        this.testRewriteFilter("/foo", "/baz", "/foo/bar%20foobar", "/baz/bar foobar");
    }

    @Test
    public void rewritePathFilterWithNamedGroupWorks() {
        this.testRewriteFilter("/foo/(?<id>\\d.*)", "/bar/baz/$\\{id}", "/foo/123", "/bar/baz/123");
    }

    private ServerWebExchange testRewriteFilter(String regex, String replacement, String actualPath, String expectedPath) {
        GatewayFilter filter = new RewritePathGatewayFilterFactory().apply(c -> c.setRegexp(regex).setReplacement(replacement));
        URI url = UriComponentsBuilder.fromUriString((String)("http://localhost" + actualPath)).build(true).toUri();
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        Assertions.assertThat((URI)webExchange.getRequest().getURI()).hasPath(expectedPath);
        URI requestUrl = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)requestUrl).hasScheme("http").hasHost("localhost").hasNoPort().hasPath(expectedPath);
        LinkedHashSet uris = (LinkedHashSet)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        Assertions.assertThat((Iterable)uris).contains((Object[])new URI[]{request.getURI()});
        return webExchange;
    }

    @Test
    public void rewritePathWithEncodedParams() {
        ServerWebExchange exchange = this.testRewriteFilter("/foo", "/baz", "/foo/bar?name=%E6%89%8E%E6%A0%B9", "/baz/bar");
        URI uri = exchange.getRequest().getURI();
        Assertions.assertThat((String)uri.getRawQuery()).isEqualTo("name=%E6%89%8E%E6%A0%B9");
    }

    @Test
    public void toStringFormat() {
        RewritePathGatewayFilterFactory.Config config = new RewritePathGatewayFilterFactory.Config().setRegexp("regexp1").setReplacement("replacement1");
        GatewayFilter filter = new RewritePathGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"regexp1"})).contains(new CharSequence[]{"replacement1"});
    }
}

