/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.SaveSessionGatewayFilterFactory;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(profiles={"save-session-web-filter"})
public class SaveSessionGatewayFilterFactoryTests
extends BaseWebClientTests {
    static WebSession mockWebSession = (WebSession)Mockito.mock(WebSession.class);

    @Test
    public void webCallShouldTriggerWebSessionSaveAction() {
        Mockito.when((Object)mockWebSession.getAttributes()).thenReturn(new HashMap());
        Mockito.when((Object)mockWebSession.save()).thenReturn((Object)Mono.empty());
        Mono result = this.webClient.get().uri("/get", new Object[0]).retrieve().bodyToMono(Map.class);
        StepVerifier.create((Publisher)result).consumeNextWith(response -> {}).expectComplete().verify(Duration.ofMinutes(10L));
        ((WebSession)Mockito.verify((Object)mockWebSession)).save();
    }

    @Test
    public void toStringFormat() {
        GatewayFilter filter = new SaveSessionGatewayFilterFactory().apply((Object)"");
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"SaveSession"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        WebSessionManager webSessionManager() {
            return exchange -> Mono.just((Object)mockWebSession);
        }
    }
}

