/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.SetStatusGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.MultiValueMap;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class SetStatusGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Autowired
    private SetStatusGatewayFilterFactory filterFactory;

    @Test
    public void setStatusIntWorks() {
        this.setStatusStringTest("www.setstatusint.org", HttpStatus.UNAUTHORIZED);
    }

    @Test
    public void setStatusStringWorks() {
        this.setStatusStringTest("www.setstatusstring.org", HttpStatus.BAD_REQUEST);
    }

    @Test
    public void nonStandardCodeWorks() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Host", "www.setcustomstatus.org");
        ResponseEntity response = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).exchange(this.baseUri + "/headers", HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        Assertions.assertThat((int)response.getStatusCodeValue()).isEqualTo(432);
    }

    @Test
    public void shouldSetStatusIntAndAddOriginalHeader() {
        String headerName = "original-http-status";
        this.filterFactory.setOriginalStatusHeaderName(headerName);
        this.setStatusStringTest("www.setstatusint.org", HttpStatus.UNAUTHORIZED).expectHeader().value(headerName, Matchers.is((Object)"[200]"));
    }

    @Test
    public void toStringFormat() {
        SetStatusGatewayFilterFactory.Config config = new SetStatusGatewayFilterFactory.Config();
        config.setStatus("401");
        GatewayFilter filter = new SetStatusGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"401"});
    }

    private WebTestClient.ResponseSpec setStatusStringTest(String host, HttpStatus status) {
        return this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{host}).exchange().expectStatus().isEqualTo(status);
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator myRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_custom_http_status", r -> r.host(new String[]{"*.setcustomstatus.org"}).filters(f -> f.setStatus(432)).uri(this.uri)).build();
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestEnumConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator enumRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("test_enum_http_status", r -> r.host(new String[]{"*.setenumstatus.org"}).filters(f -> f.setStatus(HttpStatus.UNAUTHORIZED)).uri(this.uri)).build();
        }
    }
}

