/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.StringContains;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.circuitbreaker.resilience4j.ReactiveResilience4JCircuitBreakerFactory;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactoryTests;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerResilience4JFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerTestConfig;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"debug=true", "spring.cloud.circuitbreaker.hystrix.enabled=false"})
@ContextConfiguration(classes={Config.class})
@DirtiesContext
public class SpringCloudCircuitBreakerResilience4JFilterFactoryTests
extends SpringCloudCircuitBreakerFilterFactoryTests {
    private static final String RETRIEVED_EXCEPTION = "Retrieved-Exception";
    @Autowired
    private Resilience4JCircuitBreakerFactory factory;

    @Test
    public void r4jFilterServiceUnavailable() {
        this.testClient.get().uri("/delay/3", new Object[0]).header("Host", new String[]{"www.sccbfailure.org"}).exchange().expectStatus().isEqualTo(HttpStatus.SERVICE_UNAVAILABLE);
    }

    @Test
    public void r4jFilterExceptionFallback() {
        this.testClient.get().uri("/delay/3", new Object[0]).header("Host", new String[]{"www.circuitbreakerexceptionfallback.org"}).exchange().expectStatus().isOk().expectHeader().value(RETRIEVED_EXCEPTION, StringContains.containsString((String)"TimeoutException"));
    }

    @Test
    public void cbFilterTimesoutMessage() {
        this.testClient.get().uri("/delay/3", new Object[0]).header("Host", new String[]{"www.sccbtimeout.org"}).exchange().expectStatus().isEqualTo(HttpStatus.GATEWAY_TIMEOUT).expectBody().jsonPath("$.status", new Object[0]).isEqualTo((Object)String.valueOf(HttpStatus.GATEWAY_TIMEOUT.value())).jsonPath("$.message", new Object[0]).value(StringContains.containsString((String)"1000ms"));
    }

    @Test
    public void toStringFormat() {
        SpringCloudCircuitBreakerFilterFactory.Config config = new SpringCloudCircuitBreakerFilterFactory.Config().setName("myname").setFallbackUri("forward:/myfallback");
        GatewayFilter filter = new SpringCloudCircuitBreakerResilience4JFilterFactory((ReactiveCircuitBreakerFactory)new ReactiveResilience4JCircuitBreakerFactory(), null).apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{"forward:/myfallback"});
    }

    @Test
    public void testHeadersAreClearedOnFallback() {
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("/responseheaders/502", new Object[0])).body((BodyInserter)BodyInserters.fromFormData((String)"name-1", (String)"value-1")).header("Host", new String[]{"www.circuitbreakerresetexchange.org"}).header("X-Test-Header-1", new String[]{"value1"}).accept(new MediaType[]{MediaType.APPLICATION_JSON}).exchange().expectStatus().isOk().expectHeader().doesNotExist("X-Test-Header-1").expectHeader().valueEquals("X-Test-Header-1-fallback", new String[]{"value1"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @RestController
    static class Config
    extends SpringCloudCircuitBreakerTestConfig {
        Config() {
        }

        @Bean
        public Customizer<ReactiveResilience4JCircuitBreakerFactory> slowCusomtizer() {
            return factory -> factory.addCircuitBreakerCustomizer(cb -> cb.transitionToForcedOpenState(), new String[]{"failcmd"});
        }
    }
}

